# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @describeIn icd9MajMinToCode Same as \code{icd9MajMinToCode} but assume
#' codes are already trimmed and correctly padded with zeros, e.g. E001, V09,
#' 001. This version does handle NA values correctly. ' @keywords internal
icd9MajMinToCode_alt_PrePadded <- function(mjr, mnr, isShort) {
    .Call(`_icd_icd9MajMinToCode_alt_PrePadded`, mjr, mnr, isShort)
}

icd9MajMinToCode_alt_Std <- function(mjr, mnr, isShort) {
    .Call(`_icd_icd9MajMinToCode_alt_Std`, mjr, mnr, isShort)
}

#' initialize a std::vector of strings with repeated value of the minor
#' @keywords internal
icd9MajMinToShort_alt_Std <- function(mjr, mnr) {
    .Call(`_icd_icd9MajMinToShort_alt_Std`, mjr, mnr)
}

icd9MajMinToShortSingle_alt_Std <- function(mjr, mnr) {
    .Call(`_icd_icd9MajMinToShortSingle_alt_Std`, mjr, mnr)
}

#' Convert \code{mjr} and \code{mnr} vectors to single code
#'
#' In debug mode, will check that \code{mjr} and \code{mnr} are same length.
#' @template mjr
#' @template mnr
#' @template isShort
#' @keywords internal manip
icd9MajMinToCode <- function(mjr, mnr, isShort) {
    .Call(`_icd_icd9MajMinToCode`, mjr, mnr, isShort)
}

icd9MajMinToShort <- function(mjr, mnr) {
    .Call(`_icd_icd9MajMinToShort`, mjr, mnr)
}

icd9MajMinToDecimal <- function(mjr, mnr) {
    .Call(`_icd_icd9MajMinToDecimal`, mjr, mnr)
}

#' append minor to major using std
#'
#' benefits from having reserve string size of 5
#' @keywords internal
icd9AppendMinors <- function(m, mnr, isShort) {
    invisible(.Call(`_icd_icd9AppendMinors`, m, mnr, isShort))
}

#' Set ICD short-form diagnosis code attribute
#'
#' Doing this in an R function doesn't work for 'void' equivalent, and does a
#' copy if the updated object is returned.
#' @examples
#' j <- "100"
#' attr(j, "icd_short_diag") <- TRUE
#' j
#' attr(j, "icd_short_diag") <- FALSE
#' j
#' icd:::attr_decimal_diag(j)
#' as.decimal_diag(j)
#' # if pryr is installed, use address and refs to see what is going on
#' @keywords internal attribute
attr_decimal_diag <- function(x, value = TRUE) {
    invisible(.Call(`_icd_setDecimalDiag`, x, value))
}

#' Set short diagnosis flag in C++
#' @param x Any R object
#' @param value \code{TRUE} or \code{FALSE}
#' @keywords internal attribute
attr_short_diag <- function(x, value = TRUE) {
    invisible(.Call(`_icd_setShortDiag`, x, value))
}

icd10cm_children_defined_cpp <- function(x, icd10cm2016, nc) {
    .Call(`_icd_icd10cmChildrenDefined`, x, icd10cm2016, nc)
}

icd9ComorbidShortCpp <- function(icd9df, icd9Mapping, visitId, icd9Field, threads = 8L, chunk_size = 256L, omp_chunk_size = 1L) {
    .Call(`_icd_icd9ComorbidShortCpp`, icd9df, icd9Mapping, visitId, icd9Field, threads, chunk_size, omp_chunk_size)
}

#' core search for ICD code in a map
#' @keywords internal
lookupComorbidByChunkFor <- function(vcdb, map, chunkSize, ompChunkSize, out) {
    invisible(.Call(`_icd_lookupComorbidByChunkFor`, vcdb, map, chunkSize, ompChunkSize, out))
}

#' Internal function to find ICD-10 parents
#' @param x Character vector (not factor)
#' @template mapping
#' @template visit_name
#' @template icd_name
#' @seealso \url{https://github.com/s-u/fastmatch/blob/master/src/fastmatch.c}
#' @keywords internal
icd10_comorbid_parent_search_cpp <- function(x, map, visit_name, icd_name) {
    .Call(`_icd_icd10ComorbidParentSearchCpp`, x, map, visit_name, icd_name)
}

#' @title Internal function to simplify a comorbidity map by only including codes
#' which are parents, or identical to, a given list of codes.
#' @description
#' Specifically, this is useful for ICD-10 codes where there are a huge number
#' of possible codes, but we do not want to make a comorbidity map with such a
#' large number of codes in it.
#' @param x Character vector (not factor)
#' @template mapping
#' @template visit_name
#' @template icd_name
#' @seealso \url{https://github.com/s-u/fastmatch/blob/master/src/fastmatch.c}
#' @examples
#' # one exact match, next cmb parent code, next cmb child code
#' icd10 <- as.icd10(c("I0981", "A520", "I26019"))
#' pts <- data.frame(visit_id = c("a", "b", "c"), icd10)
#' simple_map <- icd:::simplify_map_lex(icd10, icd10_map_ahrq)
#' stopifnot(simple_map$CHF == "I0981")
#' stopifnot(simple_map$PHTN != character(0))
#' stopifnot(simple_map$PVD == "I26019")
#'
#' umap <- icd:::simplify_map_lex(uranium_pathology$icd10, icd10_map_ahrq)
#' head(icd:::comorbid_common(uranium_pathology, icd10_map_ahrq,
#'                            visit_name = "case", icd_name = "icd10",
#'                            comorbid_fun = icd:::comorbidMatMul))
#'
#' @keywords internal
simplify_map_lex <- function(pt_codes, map) {
    .Call(`_icd_simplifyMapLexicographic`, pt_codes, map)
}

#' @title Comorbidity calculation as a matrix multiplication
#' @description
#' The problem is that the matrices could be huge: the patient-icd matrix would
#' be millions of patient rows, and ~15000 columns for all AHRQ comorbidities.
#' @details
#' Several ways of reducing the problem: firstly, as with existing code, we can
#' drop any ICD codes from the map which are not in the patient data. With many
#' patients, this will be less effective as the long tail becomes apparent.
#' However, with the (small) Vermont data, we see ~15,000 codes being reduced to
#' 339.
#' @section Sparse matrices:
#' Using sparse matrices is another solution. Building
#' the initial matrix may become a significant part of the calculation, but once
#' done, the solution could be a simple matrix multiplication, which is
#' potentially highly optimized (Eigen, BLAS, GPU, etc.)
#' @section Eigen:
#' Eigen has parallel (non-GPU) optimized sparse row-major *
#' dense matrix. Patients-ICD matrix must be the row-major sparse one, so the
#' dense matrix is then the comorbidity map
#' \url{https://eigen.tuxfamily.org/dox/TopicMultiThreading.html}
#' @examples
#' # show how many discrete ICD codes there are in the AHRQ map, before reducing
#' # to the number which actually appear in a group of patient visitsben
#' library(magrittr)
#' sapply(icd::icd9_map_ahrq, length) %>% sum
#' @keywords internal array algebra
comorbidMatMul <- function(icd9df, icd9Mapping, visitId, icd9Field, threads = 8L, chunk_size = 256L, omp_chunk_size = 1L) {
    .Call(`_icd_comorbidMatMul`, icd9df, icd9Mapping, visitId, icd9Field, threads, chunk_size, omp_chunk_size)
}

#' alternate comorbidity search
#'
#' alternate version using much simplified with Openmp taskloop, only in OMP4.5
#'
#' @keywords internal
lookupComorbid_alt_ByChunkForTaskloop <- function(vcdb, map, out) {
    invisible(.Call(`_icd_lookupComorbid_alt_ByChunkForTaskloop`, vcdb, map, out))
}

#' Simpler comorbidity assignment
#'
#' Re-written without OpenMP initially, but structured more simply, with the motivation of
#' using modern compiler features and OpenMP 4.5 with 'taskloop' construct.
#' \url{https://developers.redhat.com/blog/2016/03/22/what-is-new-in-openmp-4-5-3/}
#'
#' # basic test
#' # use tests/testthat/helper-base.R for two_pts and two_map
#' comorbid(two_pts, two_map, comorbid_fun = icd:::icd9Comorbid_alt_Taskloop)
#' @keywords internal
icd9Comorbid_alt_Taskloop <- function(icd9df, icd9Mapping, visitId, icd9Field, threads = 8L, chunk_size = 256L, omp_chunk_size = 1L) {
    .Call(`_icd_icd9Comorbid_alt_Taskloop`, icd9df, icd9Mapping, visitId, icd9Field, threads, chunk_size, omp_chunk_size)
}

#' @describeIn icd9Comorbid_alt_Taskloop Taskloop but finish with R transpose
#' @keywords internal
icd9Comorbid_alt_Taskloop2 <- function(icd9df, icd9Mapping, visitId, icd9Field, threads = 8L, chunk_size = 256L, omp_chunk_size = 1L) {
    .Call(`_icd_icd9Comorbid_alt_Taskloop2`, icd9df, icd9Mapping, visitId, icd9Field, threads, chunk_size, omp_chunk_size)
}

icd9MajMinToCode_alt_Old <- function(mjr, mnr, isShort) {
    .Call(`_icd_icd9MajMinToCode_alt_Old`, mjr, mnr, isShort)
}

icd9PartsToShort <- function(parts) {
    .Call(`_icd_icd9PartsToShort`, parts)
}

icd9PartsToDecimal <- function(parts) {
    .Call(`_icd_icd9PartsToDecimal`, parts)
}

icd9MajMinToParts <- function(mjr, mnr) {
    .Call(`_icd_icd9MajMinToParts`, mjr, mnr)
}

icd9ShortToPartsCpp <- function(icd9Short, mnrEmpty) {
    .Call(`_icd_icd9ShortToPartsCpp`, icd9Short, mnrEmpty)
}

#' @describeIn decimal_to_parts Convert short ICD-10 code to parts
#' @export
#' @keywords internal manip
short_to_parts.icd10 <- function(x, mnr_empty = "") {
    .Call(`_icd_icd10ShortToPartsCpp`, x, mnr_empty)
}

icd9DecimalToPartsCpp <- function(icd9Decimal, mnr_empty) {
    .Call(`_icd_icd9DecimalToPartsCpp`, icd9Decimal, mnr_empty)
}

#' @describeIn decimal_to_parts Convert decimal ICD-10 code to parts. This
#'   shares almost 100% code with the ICD-9 version: someday combine the common
#'   code.
#' @export
#' @keywords internal manip
decimal_to_parts.icd10 <- function(x, mnr_empty = "") {
    .Call(`_icd_icd10DecimalToPartsCpp`, x, mnr_empty)
}

icd9_short_to_decimal_cpp <- function(x) {
    .Call(`_icd_icd9ShortToDecimal`, x)
}

icd9_decimal_to_short_cpp <- function(x) {
    .Call(`_icd_icd9DecimalToShort`, x)
}

#' @describeIn get_major Get major part of ICD-9 code, i.e. first three
#'   digits of numeric or V code, or first four digits of E code. This is the
#'   part before the decimal, when a decimal point is used.
#' @keywords internal manip
#' @export
get_major.icd9 <- function(x, short_code) {
    .Call(`_icd_icd9GetMajor`, x, short_code)
}

#' @name fastIntToString
#' @title Fast convert integer vector to character vector
#' @description Fast conversion from integer vector to character vector using C++
#' @param x vector of integers
#' @param bufferSize int if any input strings are longer than this number
#'   (default 16) there will be memory errors. No checks done for speed.
#' @keywords internal
fastIntToString_alt_Std <- function(x) {
    .Call(`_icd_fastIntToString_alt_Std`, x)
}

#' @describeIn fastIntToString Same using \code{Rcpp}
fastIntToStringRcpp <- function(x) {
    .Call(`_icd_fastIntToStringRcpp`, x)
}

#' Guess whether codes are \code{short_code} or \code{decimal_code}
#'
#' The goal is to guess whether codes are \code{short_code} or
#' \code{decimal_code} form. Currently condense works, but not with the
#' \code{icd} look-up table currently in use. Of note, validation is a bit
#' different here, since we don't know the type until after we guess. We could
#' look for where both short_code and long are invalid, and otherwise assume
#' valid, even if the bulk are short_code. However, it may be more useful to
#' check validity after the guess.
#' @details Very quick heuristic, ploughs through ten million codes in less
#'   than one second and will stop more quickly if it finds a '.'.
#' @return single logical value, \code{TRUE} if input data are predominantly
#'   \code{short_code} type. If there is some uncertainty, then return
#'   \code{NA}.
#' @keywords internal
guess_short <- function(x_, short_code = NULL, n = 1000L, icd_name = NULL) {
    .Call(`_icd_guessShortCompleteCpp`, x_, short_code, n, icd_name)
}

guessShortPlusFactorCpp <- function(x_, n) {
    .Call(`_icd_guessShortPlusFactorCpp`, x_, n)
}

#' Do elements of vector begin with V, E (or any other character)?
#'
#' Current returns a vector of \code{bool} which is not thread safe, or
#' particularly fast, although it is memory efficient in the standard
#' implementation. As of \code{icd9} (now known as \code{icd}) version 1.2,
#' this is not called by threaded code, but this could change, so beware! ASCII
#' spaces are trimmed from the start of the string before testing, but no other
#' white space
#' @param sv vector of strings
#' @param x \code{const char*} of choices of first character to match
#' @param invert single logical, if TRUE, negates the condition
#' @keywords internal
icd9_is_n_cpp <- function(sv) {
    .Call(`_icd_icd9_is_n_cpp`, sv)
}

#' @rdname icd9_is_n_cpp
#' @keywords internal
icd9_is_v_cpp <- function(sv) {
    .Call(`_icd_icd9_is_v_cpp`, sv)
}

#' @rdname icd9_is_n_cpp
#' @keywords internal
icd9_is_e_cpp <- function(sv) {
    .Call(`_icd_icd9_is_e_cpp`, sv)
}

long_to_wide_cpp <- function(icd9df, visitId, icd9Field, aggregate = TRUE) {
    .Call(`_icd_icd9LongToWideCpp`, icd9df, visitId, icd9Field, aggregate)
}

#' Decompose a 'short' ICD code and insert the leading zeroes as needed.
#'
#' This should add leading zeroes when there is definitely no ambiguity,
#' e.g. V1. However V10 should not be altered, because V010 is a different
#' code. The goal is for this to be faster, but must be correct! Example in
#' \code{manip.cpp} has the benchmark code.
#' @keywords internal manip
icd9AddLeadingZeroes_alt_ShortSingle <- function(x) {
    .Call(`_icd_icd9AddLeadingZeroes_alt_ShortSingle`, x)
}

#' @describeIn icd9AddLeadingZeroes_alt_ShortSingle Directly apply
#' icd9AddLeadingZeroesShortSingle to each code without separating into parts
#' @keywords internal manip
icd9_add_leading_zeroes_alt_cpp <- function(x, short_code) {
    .Call(`_icd_icd9AddLeadingZeroes_alt_Direct`, x, short_code)
}

#' Simpler add leading zeroes without converting to parts and back
#' @keywords internal manip
icd9AddLeadingZeroesMajorSingle <- function(mjr) {
    .Call(`_icd_icd9AddLeadingZeroesMajorSingle`, mjr)
}

icd9AddLeadingZeroesMajorSingleStd <- function(m) {
    .Call(`_icd_icd9AddLeadingZeroesMajorSingleStd`, m)
}

icd9_add_leading_zeroes_major <- function(mjr) {
    .Call(`_icd_icd9AddLeadingZeroesMajor`, mjr)
}

#' @title Add leading zeroes to incomplete ICD-9 codes
#' @description Non-decimal ICD-9 codes with length<5 are often ambiguous. E.g.
#'   100 could be 1.00 10.0 or 100 if coded incorrectly. We must assume 100 is
#'   really 100
#' @param x Character vector of ICD-9 codes
#' @template short_code
#' @return character vector of ICD-9 codes with leading zeroes
#' @keywords internal manip
icd9_add_leading_zeroes_cpp <- function(x, short_code) {
    .Call(`_icd_icd9AddLeadingZeroes`, x, short_code)
}

#' Find child codes from vector of ICD-9 codes.
#'
#' Pure C++11 implementation using \code{unordered set} to find children of
#' given codes
#' @keywords internal
icd9ChildrenShort_alt_11 <- function(icd9Short, onlyReal) {
    .Call(`_icd_icd9ChildrenShort_alt_11`, icd9Short, onlyReal)
}

#' C++ implementation of finding children of short codes
#' @keywords internal
icd9ChildrenShort_alt_Std <- function(icd9Short, onlyReal) {
    .Call(`_icd_icd9ChildrenShort_alt_Std`, icd9Short, onlyReal)
}

icd9Children_alt_ShortNoNaUnordered <- function(icd9Short, onlyReal) {
    .Call(`_icd_icd9Children_alt_ShortNoNaUnordered`, icd9Short, onlyReal)
}

icd9ExpandMinor_alt_Std <- function(mnr, isE) {
    .Call(`_icd_icd9ExpandMinor_alt_Std`, mnr, isE)
}

icd9_expand_minor_wrap <- function(mnr, isE) {
    .Call(`_icd_icd9ExpandMinor`, mnr, isE)
}

icd9ChildrenShort <- function(icd9Short, icd9cmReal, onlyReal) {
    .Call(`_icd_icd9ChildrenShort`, icd9Short, icd9cmReal, onlyReal)
}

icd9ChildrenShortUnordered <- function(icd9Short, icd9cmReal, onlyReal) {
    .Call(`_icd_icd9ChildrenShortUnordered`, icd9Short, icd9cmReal, onlyReal)
}

icd9ChildrenDecimalCpp <- function(icd9Decimal, icd9cmReal, onlyReal) {
    .Call(`_icd_icd9ChildrenDecimalCpp`, icd9Decimal, icd9cmReal, onlyReal)
}

icd9ChildrenCpp <- function(icd9, isShort, icd9cmReal, onlyReal = TRUE) {
    .Call(`_icd_icd9ChildrenCpp`, icd9, isShort, icd9cmReal, onlyReal)
}

trimLeftCpp <- function(s) {
    .Call(`_icd_trimLeftCpp`, s)
}

strimCpp <- function(s) {
    .Call(`_icd_strimCpp`, s)
}

trimCpp <- function(sv) {
    .Call(`_icd_trimCpp`, sv)
}

get_omp_cores <- function() {
    .Call(`_icd_getOmpCores`)
}

get_omp_max_threads <- function() {
    .Call(`_icd_getOmpMaxThreads`)
}

get_omp_threads <- function() {
    .Call(`_icd_getOmpThreads`)
}

debug_parallel_env <- function() {
    invisible(.Call(`_icd_debug_parallel_env`))
}

debug_parallel <- function() {
    invisible(.Call(`_icd_debug_parallel`))
}

randomMajorCpp <- function(n) {
    .Call(`_icd_randomMajorCpp`, n)
}

#' @rdname icd9RandomShort
#' @keywords internal
icd9RandomShortN <- function(n = 5L) {
    .Call(`_icd_icd9RandomShortN`, n)
}

#' @rdname icd9RandomShort
#' @keywords internal
icd9RandomShortV <- function(n = 5L) {
    .Call(`_icd_icd9RandomShortV`, n)
}

#' @rdname icd9RandomShort
#' @keywords internal
icd9RandomShortE <- function(n = 5L) {
    .Call(`_icd_icd9RandomShortE`, n)
}

#' Generate random short-form ICD-9 codes
#'
#' Quick pseudo-random by picking numeric, 'V' or 'E' based on modulo three of
#' the number
#' @keywords internal
icd9RandomShort <- function(n = 5L) {
    .Call(`_icd_icd9RandomShort`, n)
}

valgrindCallgrindStart <- function(zerostats = FALSE) {
    .Call(`_icd_valgrindCallgrindStart`, zerostats)
}

valgrindCallgrindStop <- function() {
    .Call(`_icd_valgrindCallgrindStop`)
}

icd9_sort_cpp <- function(x) {
    .Call(`_icd_icd9SortCpp`, x)
}

icd9_order_cpp <- function(x) {
    .Call(`_icd_icd9OrderCpp`, x)
}

#' fast factor generation WIP
#' @keywords internal manip
factor_fast <- function(x) {
    .Call(`_icd_factor_fast`, x)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_icd_RcppExport_registerCCallable', PACKAGE = 'icd')
})
