% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ChildrenDecimal}
\alias{icd9ChildrenDecimal}
\title{generate all child codes for given decimal ICD9 codes}
\usage{
icd9ChildrenDecimal(icd9Decimal, onlyReal = FALSE,
  invalidAction = icd9InvalidActions)
}
\arguments{
\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{onlyReal}{single logical value, if TRUE, will limit the search to those
codes which appear in the master list, not just syntactically valid codes.
Since nearly valid, out-dated or new codes may be missed, not limiting to
'real' values will be useful. Ultimately, there will need to be annual (and
all-time) master lists of codes and the ability to test against a given
master list given the year of the ICD-9 coding.}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\value{
unsorted vector of ICD9 codes for all subsections of the provided
  code.
}
\description{
take ICD9 codes in decimal form and lists of all possible
  sub-classification codes: e.g. 1.1 returns 1.11, 1.12, 1.13 etc. There are
  no codes like 1.10 which are distinct from 1.1, so this can be purely
  numeric Also, note that expanding "100.0" (100.00 to 100.09) is different
  from expanding "100.00" (no expansion) \code{0.1 == .3/3} is a problem...
  \url{http://cran.r-project.org/doc/FAQ/R-FAQ.html#Why-doesn_0027t-R-think-these-numbers-are-equal_003f}
}
\examples{
#icd9ChildrenDecimal("100.1")
#icd9ChildrenDecimal("2.34")
}
\seealso{
Other ICD-9 ranges: \code{\link{\%i9d\%}},
  \code{\link{icd9ExpandRangeDecimal}};
  \code{\link{\%i9mj\%}},
  \code{\link{icd9ExpandRangeMajor}};
  \code{\link{\%i9s\%}},
  \code{\link{icd9ExpandRangeShort}};
  \code{\link{icd9Children}},
  \code{\link{icd9ChildrenShort}};
  \code{\link{icd9CondenseToExplain}};
  \code{\link{icd9CondenseToMajor}};
  \code{\link{icd9ExpandMinor}},
  \code{\link{icd9ExpandMinorE}},
  \code{\link{icd9ExpandMinorNV}};
  \code{\link{icd9PrecedingMinors}},
  \code{\link{icd9SubsequentMinors}}
}
\keyword{manip}

