% Generated by roxygen2 (4.0.1): do not edit by hand
\name{icd9ShortToDecimal}
\alias{icd9ShortToDecimal}
\title{convert short-form ICD-9 code to decimal form}
\usage{
icd9ShortToDecimal(icd9Short, invalidAction = icd9InvalidActions)
}
\arguments{
\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is given
in a code, then the digits are greedily assigned to hundreds, then tens,
then units, before the decimal parts. E.g. "10" becomes "010", not "0010"}

\item{invalidAction}{character string (unit length) containing one of:
  "ignore", "silent", "warn", "stop"

  - \code{ignore} no check for validity of ICD-9 code is made implicitly.
  This is the fastest option. If the function call is explicitly to check
  validity, e.g. icd9ValidShort(icd9Short = "12345", invalidAction =
  "ignore"), then the behavior is the same as \code{silent}.

  - \code{silent} invalid ICD-9 codes are replaced silently by \code{NA}
  (actually \code{NA_character_}). If the function returns \code{TRUE} or
  \code{FALSE} rather than the ICD-9 code itself, then \code{FALSE} is
  returned

  - \code{warn} invalid ICD-9 codes are replaced by \code{NA} with a warning
  revealing the invalid code(s).

  - \code{stop} stop with error if any invalid codes are found in input. This
  is the preferred method when doing one-time validation, e.g. of the
  co-morbidity mapping lists.}
}
\description{
converts ICD-9 'short' form to decimal form
}
\seealso{
Other ICD-9 convert: \code{\link{icd9DecimalToShort}};
  \code{\link{icd9DropLeadingZeroes}},
  \code{\link{icd9DropLeadingZeroesDecimal}},
  \code{\link{icd9DropLeadingZeroesMajor}},
  \code{\link{icd9DropLeadingZeroesShort}};
  \code{\link{icd9MajMinToDecimal}},
  \code{\link{icd9MajMinToParts}},
  \code{\link{icd9MajMinToShort}},
  \code{\link{icd9PartsRecompose}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToShort}},
  \code{\link{icd9PartsToShort}}
}
\keyword{manip}

