% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taf.roxygenise.R
\name{taf.roxygenise}
\alias{taf.roxygenise}
\title{Process a TAF repo with the taf roclet}
\usage{
taf.roxygenise(path = ".", files)
}
\arguments{
\item{path}{location of taf repository top level directory. Default
is working directory.}

\item{files}{a vector of file names to parse for documentation.}
}
\description{
This function builds documentation for a TAF repository
using roxygen syntax headers.  It depends on the roxygen2
package adding some extra functionality to produce citation
entries for data sources
}
\examples{
\dontrun{

# Create boot folder
mkdir("boot")

# Create boot script, boot/mydata.R
draft.data.script(name="mydata", title="Title", description="Description",
                  format="txt", originator="Me", year="2022",
                  period=c(2000,2020), access="Public",
                  content='write(pi, file="pi.txt")')

# Create metadata, boot/DATA.bib
taf.roxygenise(files="mydata.R")

# Run boot script, creating boot/data/mydata/pi.txt
taf.boot()
}

}
