% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{duplicate}
\alias{duplicate}
\title{Duplicates of expand.grid for 2 Variables}
\usage{
duplicate(n, identical = FALSE)
}
\arguments{
\item{n}{the length of vector passed to expand.grid.}

\item{identical}{defaults to FALSE to not select the elements where the 2 items
are identical. Set to TRUE to also include these. The output of
expand.grid, subset to remove duplicates with 'identical' set to TRUE would
be the equivalent of \code{utils::combn(n, 2)}.}
}
\value{
A numeric vector.
}
\description{
Create a vector of element positions of duplicates in the output of expand.grid
    on 2 identical vectors. A much faster method of creating combinations for
    2 variabes vs. the combn() function from the utils package.
}
\examples{
n <- 3
expand.grid(1:n, 1:n)
expand.grid(1:n, 1:n)[-duplicate(n), ]
expand.grid(1:n, 1:n)[-duplicate(n, identical = TRUE), ]

}
