test_that("archive functions ok", {
  skip_if_not_installed("openssl")
  object <- ichimoku(sample_ohlc_data)
  file <- tempfile()
  archive(object = object, file = file)
  restored <- archive(file = file)
  unlink(file)
  expect_identical(restored, object)
  expect_error(archive(), "0 arguments passed")
  expect_error(archive(object, object, object), "3 arguments passed")
  expect_error(archive(object), "supplied as a string")
  expect_error(archive(object, object), "supplied as a string")
  expect_error(archive(object = object), "specified without")
  file <- tempfile()
  save(sample_ohlc_data, file = file)
  expect_error(archive(file), "was not created")
  unlink(file)
  file <- tempfile()
  x_archive_sha256 <- NA
  save(object, x_archive_sha256, file = file)
  expect_message(archive(file), "unverified")
  unlink(file)
  x_archive_sha256 <- "010101010101"
  file <- tempfile()
  save(object, x_archive_sha256, file = file)
  expect_warning(archive(file), "does not match the original")
  unlink(file)
})
