% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{matrix_df}
\alias{matrix_df}
\title{Convert matrix to data.frame}
\usage{
matrix_df(x, keep.attrs = FALSE)
}
\arguments{
\item{x}{a matrix.}

\item{keep.attrs}{[default FALSE] if set to TRUE, will preserve any custom
attributes set on the original object.}
}
\value{
A 'data.frame' object. If the matrix has row names, these are
    retained by the dataframe.
}
\description{
An optimised 'matrix' to 'data.frame' constructor.
}
\details{
The optimised data.frame constructors are used internally within
    the package and made available as utilities. Please note that no data
    validation or checking is performed.
}
\examples{
cloud <- ichimoku(sample_ohlc_data)
mcloud <- as.matrix(cloud)
df <- matrix_df(mcloud)
str(df)
str(rownames(df))

}
