% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_imputation.R
\name{imFitModel}
\alias{imFitModel}
\title{Model fitting}
\usage{
imFitModel(data.all = NULL, lst.var = NULL)
}
\arguments{
\item{data.all}{Original dataset}

\item{lst.var}{see \code{\link{idem-parameters}}}
}
\value{
A class \code{IDEM.FIT} list of modeling fitting results with the following items
\describe{
\item{lst.var}{List of parameters}
\item{rst.mdl}{A list of modeling fitting results for each model with
    \describe{
      \item{lm}{results from function \code{lm}}
      \item{formula}{model formula}
      \item{coef}{model coefficients}
      \item{res}{residuals}
      \item{h}{bandwidth of residuals for kernel density estimation}}
}}
}
\description{
Fit linear imputation models to the observed data from complete survivors for
each treatment arm at each time point
}
\examples{

lst.var <- list(trt="TRT", surv="SURV", outcome=c("Y1","Y2"), y0=NULL,
                endp=c("Y2"), unitTime="days",
                trt.label = c("UC+SBT", "SAT+SBT"),
                cov=c("AGE"), endfml="Y2", duration=365, bounds=c(0,100));

rst.fit <- imFitModel(abc, lst.var);

}
