test_that("identical_graphs works", {
  g <- make_ring(5)
  g2 <- make_ring(5)

  expect_true(identical_graphs(g, g2))

  g2 <- make_ring(6)

  expect_false(identical_graphs(g, g2))
})

test_that("identical_graphs considers attributes", {
  g <- barabasi.game(10)
  g2 <- g

  expect_true(identical_graphs(g, g2))

  g2$m <- 2

  expect_false(identical_graphs(g, g2))
  expect_true(identical_graphs(g, g2, attrs = FALSE))
})
