% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structural.properties.R
\name{unfold_tree}
\alias{unfold_tree}
\title{Convert a general graph into a forest}
\usage{
unfold_tree(graph, mode = c("all", "out", "in", "total"), roots)
}
\arguments{
\item{graph}{The input graph, it can be either directed or undirected.}

\item{mode}{Character string, defined the types of the paths used for the
breadth-first search. \dQuote{out} follows the outgoing, \dQuote{in} the
incoming edges, \dQuote{all} and \dQuote{total} both of them. This argument
is ignored for undirected graphs.}

\item{roots}{A vector giving the vertices from which the breadth-first
search is performed. Typically it contains one vertex per component.}
}
\value{
A list with two components: \item{tree}{The result, an \code{igraph}
object, a tree or a forest.} \item{vertex_index}{A numeric vector, it gives
a mapping from the vertices of the new graph to the vertices of the old
graph.}
}
\description{
Perform a breadth-first search on a graph and convert it into a tree or
forest by replicating vertices that were found more than once.
}
\details{
A forest is a graph, whose components are trees.

The \code{roots} vector can be calculated by simply doing a topological sort
in all components of the graph, see the examples below.
}
\examples{

g <- make_tree(10) \%du\% make_tree(10)
V(g)$id <- seq_len(vcount(g)) - 1
roots <- sapply(decompose(g), function(x) {
  V(x)$id[topo_sort(x)[1] + 1]
})
tree <- unfold_tree(g, roots = roots)

}
\seealso{
Other structural.properties: 
\code{\link{bfs}()},
\code{\link{component_distribution}()},
\code{\link{connect}()},
\code{\link{constraint}()},
\code{\link{coreness}()},
\code{\link{degree}()},
\code{\link{dfs}()},
\code{\link{distance_table}()},
\code{\link{edge_density}()},
\code{\link{feedback_arc_set}()},
\code{\link{girth}()},
\code{\link{is_acyclic}()},
\code{\link{is_dag}()},
\code{\link{is_matching}()},
\code{\link{k_shortest_paths}()},
\code{\link{knn}()},
\code{\link{laplacian_matrix}()},
\code{\link{reciprocity}()},
\code{\link{subcomponent}()},
\code{\link{subgraph}()},
\code{\link{topo_sort}()},
\code{\link{transitivity}()},
\code{\link{which_multiple}()},
\code{\link{which_mutual}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{structural.properties}
\keyword{graphs}
