% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/cimg_class.R
\name{subim}
\alias{subim}
\title{Select part of an image}
\usage{
subim(im, ...)
}
\arguments{
\item{im}{an image}

\item{...}{various conditions defining a rectangular image region}
}
\value{
an image with some parts cut out
}
\description{
subim selects an image part based on coordinates: it allows you to select a subset of rows, columns, frames etc. Refer to the examples to see how it works
}
\examples{
parrots <- load.image(system.file('extdata/parrots.png',package='imager'))
subim(parrots,x < 30) #Only the first 30 columns
subim(parrots,y < 30) #Only the first 30 rows
subim(parrots,x < 30,y < 30) #First 30 columns and rows
subim(parrots, sqrt(x) > 8) #Can use arbitrary expressions
subim(parrots,x > height/2,y > width/2)  #height and width are defined based on the image
subim(parrots,cc==1) #Colour axis is "cc" not "c" here because "c" is an important R function
##Not run
##subim(parrots,x+y==1)
##can't have expressions involving interactions between variables (domain might not be square)
}
\author{
Simon Barthelme
}

