% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/extrFP.R
\name{extrFP}
\alias{extrFP}
\alias{extrFP,BasicData-method}
\alias{extrFP.BasicData}
\title{extrFP}
\usage{
extrFP(drug_target, disease_biomarker, method = "enrich")

\S4method{extrFP}{BasicData}(drug_target, disease_biomarker, method = "enrich")

extrFP.BasicData(drug_target, disease_biomarker, method = "enrich")
}
\arguments{
\item{drug_target}{A data frame or list of drug target.}

\item{disease_biomarker}{A character of disease biomarkers or an order ranked geneList.}

\item{method}{one of "enrich" and "gsea"}
}
\value{
ScoreFP object

ScoreFP object
}
\description{
Calculate the pathway fingerprints
}
\examples{

  data("drugSample")
  drug_herb <- PrepareData(drugSample$drug_herb, col1 = "drug", col2 = "herb")
  herb_target <- PrepareData(drugSample$herb_target,
                             col1 = "herb", col2 = "target",
                             format = "basket", sep = ", ")
  drug_target <- CreateBasicData(drug_herb, herb_target)
  FP <- extrFP(drug_target = drug_target,
               disease_biomarker = drugSample$disease_biomarker,
               method = "enrich")
}
\author{
Yuanlong Hu
}
