% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hub_seqs_exclusion.R
\name{hub_seqs_exclusion}
\alias{hub_seqs_exclusion}
\title{Deletes top hub sequences from repertoire, changing the network architecture.}
\usage{
hub_seqs_exclusion(repertoire, top_x = 0.005, report = FALSE,
  output_dir = "", verbose = TRUE)
}
\arguments{
\item{repertoire}{An annotated AIRR compliant repertoire.

(http://docs.airr-community.org/en/latest/)}

\item{top_x}{Determines what percentage of hub sequences get excluded

(Default: 0.005, i.e. Top 0.5 percent)}

\item{report}{The user can choose to output a report csv file containing the excluded
sequences. (Default: FALSE)}

\item{output_dir}{If user specifies and output directory a csv file containing
the excluded sequences is saved at that path, otherwise it will be saved in tempdir().}

\item{verbose}{Determines whether messages on plot locations are output to user. (Default: TRUE)}
}
\value{
Repertoire reduced by hub sequence (new network architecture)
}
\description{
Deletes top hub sequences from repertoire, changing the network architecture.
}
\examples{
repertoire <- list_example_repertoires[["example_repertoire_A"]]
rep_excluded_hubs <- hub_seqs_exclusion(repertoire, top_x = 0.005, output_dir = "")
}
