% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateTupelData.R
\name{generateTupelData}
\alias{generateTupelData}
\title{Tuple representation}
\usage{
generateTupelData(data, constraints = NULL)
}
\arguments{
\item{data}{a data.frame object, with potentially
imprecise entries; see 'Note'.}

\item{constraints}{a list of so-called logical constraints or
fixed zeros. Each element must be an object of class
\code{"impimp_event"}. See 'Details'.}
}
\value{
A list of length \code{NROW(data)} of data.frames
for the observation within the original data.frame.

Each such data.frame contains the precise observations which
are compatible with its imprecise representation.
}
\description{
Generating a tuple representation of a
data.frame with imprecise observations
}
\details{
By specifying \code{constraints} one can exlude combinations of
imputed values which are deemed impossible, so called
\sQuote{logical constraints} or \sQuote{fixed zeros}.
}
\note{
No sanity check is performed on whether \code{data} actually
contains imprecise observations or is in the form for denoting
imprecision throughoutly used in the impimp-package. A warning is
triggered if it is not of class \code{"impimp"}.
}
\examples{
A <- data.frame(x1 = c(1,0), x2 = c(0,0),
                y1 = c(1,0), y2 = c(2,2))
B <- data.frame(x1 = c(1,1,0), x2 = c(0,0,0),
                z1 = c(0,1,1), z2 = c(0,1,2))
AimpB <- impimp(A, B, method = "domain")

## no constraints
generateTupelData(AimpB)

## (y1,z1) = (0,0) as constraint
generateTupelData(AimpB, list(impimp_event(y1 = 0, z1 = 0)))

\donttest{
data(iris)
generateTupelData(iris) # emits a warning
}
}
\seealso{
\code{\link{impimp}}, \code{\link{impimp_event}} for
sepcifying the constraints
}
\keyword{datagen}
