% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_peak.R
\name{estimate_peak}
\alias{estimate_peak}
\alias{estimate_peaks}
\title{Estimate the peak date of an incidence curve}
\usage{
estimate_peak(x, n = 100L, alpha = 0.05, first_only = TRUE, progress = TRUE)
}
\arguments{
\item{x}{An \link[=incidence]{incidence2} object.}

\item{n}{\code{integer}.

The number of bootstrap datasets to be generated; defaults to 100.

\verb{[double]} vectors will be converted via \code{as.integer(n)}.}

\item{alpha}{\code{numeric}.

The type 1 error chosen for the confidence interval; defaults to 0.05.}

\item{first_only}{\code{bool}.

Should only the first peak (by date) be kept.

Defaults to \code{TRUE}.}

\item{progress}{\code{bool}.

Should a progress bar be displayed (default = TRUE)}
}
\value{
A data frame with the the following columns:
\itemize{
\item \code{observed_date}: the date of peak incidence of the original dataset.
\item \code{observed_count}: the peak incidence of the original dataset.
\item \code{estimated}: the median peak time of the bootstrap datasets.
\item \code{lower_ci/upper_ci}: the confidence interval based on bootstrap datasets.
\item \code{bootstrap_peaks}: a nested tibble containing the the peak times of the
bootstrapped datasets.
}
}
\description{
This function can be used to estimate the peak of an epidemic curve using
bootstrapped samples of the available data.
}
\details{
Input dates are resampled with replacement to form bootstrapped datasets;
the peak is reported for each, resulting in a distribution of peak times.
When there are ties for peak incidence, only the first date is reported.

Note that the bootstrapping approach used for estimating the peak time makes
the following assumptions:
\itemize{
\item the total number of event is known (no uncertainty on total incidence)
\item dates with no events (zero incidence) will never be in bootstrapped
datasets
\item the reporting is assumed to be constant over time, i.e. every case is
equally likely to be reported
}
}
\examples{
\dontshow{.old <- data.table::setDTthreads(2)}
if (requireNamespace("outbreaks", quietly = TRUE)) {

  # load data and create incidence
  data(fluH7N9_china_2013, package = "outbreaks")
  i <- incidence(fluH7N9_china_2013, date_index = "date_of_onset")

  # find 95\% CI for peak time using bootstrap
  estimate_peak(i)
}
\dontshow{data.table::setDTthreads(.old)}

}
\seealso{
\code{\link[=bootstrap_incidence]{bootstrap_incidence()}} for the bootstrapping underlying this approach and
\code{\link[=keep_peaks]{keep_peaks()}} to get the peaks in a single
\link[=incidence]{incidence2} object.
}
\author{
Thibaut Jombart and Tim Taylor, with inputs on caveats from Michael Höhle.
}
