% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delay_estimation.R
\name{geomSpaceFactory}
\alias{geomSpaceFactory}
\title{Factory Method for Negative Maximum Spacing Estimation (MSE) Objective Function}
\usage{
geomSpaceFactory(
  x,
  y = NULL,
  distribution = c("exponential", "weibull"),
  bind = NULL,
  ties = c("equidist", "density", "random", "none"),
  verbose = 0L
)
}
\arguments{
\item{x}{numeric. observations}

\item{y}{numeric. observations in second group.}

\item{distribution}{character(1). delayed distribution family}

\item{bind}{character. parameter names that are bind together (i.e. equated) between both groups}

\item{ties}{character. How to handle ties within data of a group.}

\item{verbose}{integer flag. How much verbosity in output? The higher the more output. Default value is 0 which is no output.}
}
\value{
An R-function that returns the negative MSE criterion for given choice of model parameters.
}
\description{
Given the observed data this factory method produces an MSE objective function implementation
which is the negative of the MSE-criterion H.
}
\details{
From the observations, negative or infinite values are discarded.
}
