% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infer-two-samp-var-test-shiny.R
\name{var_test_shiny}
\alias{var_test_shiny}
\title{Two Sample Variance Comparison Test Shiny}
\usage{
var_test_shiny(data, variable1, variable2, alternative = c("less", "greater",
  "all"))
}
\arguments{
\item{data}{a dataframe}

\item{variable1}{character; name of sample 1 in data frame}

\item{variable2}{character; name of sample 2 in data frame}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of "both" (default), "greater", "less" or "all". You can specify
just the initial letter.}
}
\value{
\code{var_test} returns an object of class \code{"var_test"}.
An object of class \code{"var_test"} is a list containing the
following components:

\item{f}{f statistic}
\item{lower}{lower one-sided p-value}
\item{upper}{upper one-sided p-value}
\item{two_tail}{two-sided p-value}
\item{vars}{variances for each level of the grouping variable}
\item{avgs}{means for each level of the grouping variable}
\item{sds}{standard deviations for each level of the grouping variable}
\item{ses}{standard errors for each level of the grouping variable}
\item{avg}{combined mean}
\item{sd}{combined standard deviation}
\item{se}{estimated combined standard error}
\item{n1}{numerator degrees of freedom}
\item{n2}{denominator degrees of freedom}
\item{lens}{number of observations for each level of grouping variable}
\item{len}{number of observations}
\item{lev}{levels of the grouping variable}
\item{type}{alternative hypothesis}
}
\description{
\code{var_test} performs tests on the equality of standard
deviations (variances).
}
\examples{
# using two variables
# lower tail
var_test_shiny(hsb, 'read', 'write', alternative = 'less')

# upper tail
var_test_shiny(hsb, 'read', 'write', alternative = 'greater')

# all tails
var_test_shiny(hsb, 'read', 'write', alternative = 'all')

}
\references{
Sheskin, D. J. 2007. Handbook of Parametric and Nonparametric
Statistical Procedures, 4th edition. : Chapman & Hall/CRC.
}
\seealso{
\code{\link[stats]{var.test}}
}
