% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{cond.prob.analysis}
\alias{cond.prob.analysis}
\alias{CPA}
\title{Conditional probability of deviation from means}
\usage{
cond.prob.analysis(data, nodes.colname, Desired.colname, Condition.colname)
}
\arguments{
\item{data}{A data frame containing the values of two continuous variables and the name of
observations (nodes).}

\item{nodes.colname}{The character format (quoted) name of the column containing
the name of observations (nodes).}

\item{Desired.colname}{The character format (quoted) name of the column containing
the values of the desired variable.}

\item{Condition.colname}{The character format (quoted) name of the column containing
the values of the condition variable.}
}
\value{
A list of two objects including the conditional probability of deviation of two
centrality measures (or any two other continuous variables) from their corresponding
means in opposite directions based on both the entire network and the split-half random
sample of network nodes.
}
\description{
This function calculates the conditional probability of deviation of two
centrality measures (or any two other continuous variables) from their corresponding
means in opposite directions.
}
\examples{
MyData <- centrality.measures
My.conditional.prob <- cond.prob.analysis(data = MyData,
                                          nodes.colname = rownames(MyData),
                                          Desired.colname = "BC",
                                          Condition.colname = "NC")
}
\seealso{
Other centrality association assessment functions: 
\code{\link{double.cent.assess.noRegression}()},
\code{\link{double.cent.assess}()}
}
\concept{centrality association assessment functions}
\keyword{association_assessment}
\keyword{conditional_probability}
