# Influx OSS API Service
#
# No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
#
# The version of the OpenAPI document: 2.0.0
#
# Generated by: https://openapi-generator.tech

#' @docType class
#' @title Ready operations
#' @description influxdbclient.Ready
#' @format An \code{R6Class} generator object
#' @field apiClient Handles the client-server communication.
#'
#' @section Methods:
#' \describe{
#' \strong{ GetReady } \emph{ Get the readiness of an instance at startup }
#' 
#'
#' \itemize{
#' \item \emph{ @param } zap.trace.span character
#' \item \emph{ @returnType } \link{Ready} \cr
#'
#'
#' \item status code : 200 | The instance is ready
#'
#' \item return type : Ready 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' \item status code : 0 | Non 2XX error response from server.
#'
#' \item return type : Error 
#' \item response headers :
#'
#' \tabular{ll}{
#' }
#' }
#'
#' }
#'
#'
#' @examples
#' \dontrun{
#' ####################  GetReady  ####################
#'
#' library(influxdbclient)
#' var.zap.trace.span <- '{\"trace_id\":\"1\",\"span_id\":\"1\",\"baggage\":{\"key\":\"value\"}}' # character | OpenTracing span context
#'
#' #Get the readiness of an instance at startup
#' api.instance <- ReadyApi$new()
#'
#' result <- api.instance$GetReady(zap.trace.span=var.zap.trace.span)
#'
#'
#' }
#' @importFrom R6 R6Class
#' @importFrom base64enc base64encode
#' @export
ReadyApi <- R6::R6Class(
  'ReadyApi',
  public = list(
    apiClient = NULL,
    initialize = function(apiClient){
      if (!missing(apiClient)) {
        self$apiClient <- apiClient
      }
      else {
        self$apiClient <- ApiClient$new()
      }
    },
    GetReady = function(zap.trace.span=NULL, ...){
      apiResponse <- self$GetReadyWithHttpInfo(zap.trace.span, ...)
      resp <- apiResponse$response
      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        apiResponse$content
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        apiResponse
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        apiResponse
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        apiResponse
      }
    },

    GetReadyWithHttpInfo = function(zap.trace.span=NULL, ...){
      args <- list(...)
      queryParams <- list()
      headerParams <- c()

      if (!is.null(`zap.trace.span`)) {
        headerParams['Zap-Trace-Span'] <- `zap.trace.span`
      }

      body <- NULL
      urlPath <- "/ready"

      resp <- self$apiClient$CallApi(url = paste0(self$apiClient$basePath, urlPath),
                                 method = "GET",
                                 queryParams = queryParams,
                                 headerParams = headerParams,
                                 body = body,
                                 ...)

      if (httr::status_code(resp) >= 200 && httr::status_code(resp) <= 299) {
        deserializedRespObj <- tryCatch(
          self$apiClient$deserialize(resp, "Ready", loadNamespace("influxdbclient")),
          error = function(e){
             stop("Failed to deserialize response")
          }
        )
        ApiResponse$new(deserializedRespObj, resp)
      } else if (httr::status_code(resp) >= 300 && httr::status_code(resp) <= 399) {
        ApiResponse$new(paste("Server returned " , httr::status_code(resp) , " response status code."), resp)
      } else if (httr::status_code(resp) >= 400 && httr::status_code(resp) <= 499) {
        ApiResponse$new("API client error", resp)
      } else if (httr::status_code(resp) >= 500 && httr::status_code(resp) <= 599) {
        ApiResponse$new("API server error", resp)
      }
    }
  )
)
