% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment.R
\name{bru_log_reset}
\alias{bru_log_reset}
\title{Clear log contents}
\usage{
bru_log_reset(x = NULL, bookmark = NULL, offset = NULL)
}
\arguments{
\item{x}{A \code{bru_log} object, or in some cases, and object that can be
converted/extracted to a \code{bru_log} object. \code{NULL} denotes the global
\code{inlabru} log object.}

\item{bookmark}{character; The label for a bookmark with a stored offset.}

\item{offset}{integer; a position offset in the log, with \code{0L} pointing at
the start of the log. If negative, denotes the point \code{abs(offset)} elements
from tail of the log. When \code{bookmark} is non-NULL, the \code{offset} applies a
shift (forwards or backwards) to the bookmark list.}
}
\value{
Returns (invisibly) the modified \code{bru_log} object, or \code{NULL} (when \code{x} is \code{NULL})
}
\description{
Clears the log contents up to
a given \code{offset} or \code{bookmark}. Default: clear the entire log.
When \code{x} is NULL, the global \code{inlabru} log is updated, and \code{invisible(NULL)}
is returned. Otherwise the updated object is returned (invisibly).
}
\examples{
\dontrun{
if (interactive()) {
  bru_log_reset()
}
}
}
\seealso{
Other inlabru log methods: 
\code{\link{bru_log}()},
\code{\link{bru_log_bookmark}()},
\code{\link{bru_log_message}()},
\code{\link{bru_log_new}()},
\code{\link{bru_log_offset}()}
}
\concept{inlabru log methods}
