% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inla.R
\name{extract_property}
\alias{extract_property}
\title{Extract a summary property from all results of an inla result}
\usage{
extract_property(result, property, internal_hyperpar = FALSE)
}
\arguments{
\item{result}{an \code{inla} result object}

\item{property}{character; "mean", "sd", "mode", or some other column
identifier for inla result \verb{$summary.fixed}, \verb{$summary.random$label}, and
\verb{$summary.hyperpar}, or "joint_mode". For "joint_mode", the joint latent mode
is extracted, and the joint hyperparameter mode, in the internal scale.}

\item{internal_hyperpar}{logical; if \code{TRUE}, use internal scale for
hyperparamter properties. Default is \code{FALSE}, except when \code{property} is
"joint_mode" which forces \code{internal_hyperpar=TRUE}.}
}
\value{
named list for each estimated fixed effect coefficient,
random effect vector, and hyperparameter. The hyperparameter names are
standardised with \code{\link[=bru_standardise_names]{bru_standardise_names()}}
}
\description{
Extract a summary property from all results of an inla result
}
\keyword{internal}
