% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{evaluate_effect_single}
\alias{evaluate_effect_single}
\alias{evaluate_effect_multi}
\alias{evaluate_effect_single.component}
\alias{evaluate_effect_single.component_list}
\alias{evaluate_effect_multi.component}
\alias{evaluate_effect_multi.component_list}
\title{Evaluate a component effect}
\usage{
evaluate_effect_single(...)

evaluate_effect_multi(...)

\method{evaluate_effect_single}{component}(component, state, data, A = NULL, ...)

\method{evaluate_effect_single}{component_list}(components, state, data, A = NULL, ...)

\method{evaluate_effect_multi}{component}(component, state, data, A = NULL, ...)

\method{evaluate_effect_multi}{component_list}(components, state, data, A = NULL, ...)
}
\arguments{
\item{...}{Unused.}

\item{component}{A \code{bru_component}.}

\item{state}{Specification of one (for \code{evaluate_effect_single}) or several
(for \code{evaluate_effect_multi}) latent variable states:
\itemize{
\item \code{evaluate_effect_single.component}: A vector of the latent component state.
\item \code{evaluate_effect_single.component_list}: list of named vectors.
\item \code{evaluate_effect_multi}: list of lists of the \code{evaluate_effect_single.component_list} type.
For \code{evaluate_effect_multi.component},
only the label for the given component needs to be included
}}

\item{data}{A \code{data.frame} or Spatial* object of covariates and/or point locations.}

\item{A}{A matrix overriding the default projection matrix or matrices
(named list of matrices for \code{evaluate_effect.component_list})}
}
\value{
\itemize{
\item \code{evaluate_effect_single.component}: A numeric vector of the component effect values
state.
}

\itemize{
\item \code{evaluate_effect_single.component_list}: A list of evaluated
component effect values
}

\itemize{
\item \code{evaluate_effect_multi.component}: A list of numeric vectors
of evaluated component effects.
}

\itemize{
\item \code{evaluate_effect_multi.component_list}: A list of lists of
evaluated component effects, one list for each state
}
}
\description{
Calculate latent component effects given some data and the state of the
component's internal random variables.
}
\author{
Fabian E. Bachl \email{bachlfab@gmail.com} and
Finn Lindgren \email{finn.lindgren@gmail.com}
}
\keyword{internal}
