% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.toygroups.R
\docType{data}
\name{toygroups}
\alias{toygroups}
\title{Simulated 1D animal group locations and group sizes}
\format{
The data are a list that contains these elements:
\describe{
\item{\code{groups}:}{ A \code{data.frame} of group locations \code{x} and size \code{size}}
\item{\code{df.size}:}{ IGNORE THIS }
\item{\code{df.intensity}:}{ A \code{data.frame} with Poisson process
intensity \code{d.lambda} at locations \code{x}}
\item{\code{df.rate}:}{ A \code{data.frame} the locations \code{x} and associated \code{rate} which
parameterized the exponential distribution from which the group sizes were drawn.}
}
}
\usage{
data(toygroups)
}
\description{
This data set serves to teach the concept of modelling species that gather in groups and where
the grouping behaviour depends on space.
}
\examples{
\donttest{
if (require(ggplot2, quietly = TRUE)) {
  # Load the data

  data("toygroups", package = "inlabru")

  # The data set is a simulation of animal groups residing in a 1D space. Their
  # locations in x-space are sampled from a Cox process with intensity

  ggplot(toygroups$df.intensity) +
    geom_line(aes(x = x, y = g.lambda))

  # Adding the simulated group locations to this plot we obtain

  ggplot(toygroups$df.intensity) +
    geom_line(aes(x = x, y = g.lambda)) +
    geom_point(data = toygroups$groups, aes(x, y = 0), pch = "|")

  # Each group has a size mark attached to it.
  # These group sizes are sampled from an exponential distribution
  # for which the rate parameter depends on the x-coordinate

  ggplot(toygroups$groups) +
    geom_point(aes(x = x, y = size))

  ggplot(toygroups$df.rate) +
    geom_line(aes(x, rate))
}
}
}
