% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmesher_crs.R
\name{fm_crs_is_null}
\alias{fm_crs_is_null}
\alias{fm_crs}
\alias{fm_crs_oblique}
\alias{fm_crs_oblique<-}
\alias{print.fm_crs}
\alias{fm_crs.default}
\alias{st_crs.fm_crs}
\alias{$.fm_crs}
\alias{fm_crs.fm_crs}
\alias{fm_crs.inla.CRS}
\alias{fm_crs.character}
\alias{fm_crs.Spatial}
\alias{fm_crs.SpatVector}
\alias{fm_crs.SpatRaster}
\alias{fm_crs.sf}
\alias{fm_crs.sfc}
\alias{fm_crs.sfg}
\alias{fm_crs.inla.mesh}
\alias{fm_crs.inla.mesh.lattice}
\alias{fm_crs.inla.mesh.segment}
\alias{fm_wkt_predef}
\title{Obtain coordinate reference system object}
\usage{
fm_crs_is_null(x)

fm_crs(x, ..., crsonly = FALSE)

fm_crs_oblique(x)

fm_crs_oblique(x) <- value

\method{print}{fm_crs}(x, ...)

\method{fm_crs}{default}(x, ..., crsonly = FALSE)

\method{st_crs}{fm_crs}(x, ...)

\method{$}{fm_crs}(x, name)

\method{fm_crs}{fm_crs}(x, ..., crsonly = FALSE)

\method{fm_crs}{inla.CRS}(x, ..., crsonly = FALSE)

\method{fm_crs}{character}(x, ..., crsonly = FALSE)

\method{fm_crs}{Spatial}(x, ..., crsonly = FALSE)

\method{fm_crs}{SpatVector}(x, ..., crsonly = FALSE)

\method{fm_crs}{SpatRaster}(x, ..., crsonly = FALSE)

\method{fm_crs}{sf}(x, ..., crsonly = FALSE)

\method{fm_crs}{sfc}(x, ..., crsonly = FALSE)

\method{fm_crs}{sfg}(x, ..., crsonly = FALSE)

\method{fm_crs}{inla.mesh}(x, ..., crsonly = FALSE)

\method{fm_crs}{inla.mesh.lattice}(x, ..., crsonly = FALSE)

\method{fm_crs}{inla.mesh.segment}(x, ..., crsonly = FALSE)

fm_wkt_predef()
}
\arguments{
\item{x}{Object to convert to \code{crs} or  to extract \code{crs} information from.
If \code{character}, a string suitable for \code{sf::st_crs(x)}, or the name of a
predefined \code{wkt} string from ``names(fm_wkt_predef())`.}

\item{\dots}{Additional parameters. Not currently in use.}

\item{crsonly}{logical; if \code{TRUE}, remove any \code{oblique} information
for \code{fm_crs} class objects and return a pure \code{crs} class object. Default: \code{FALSE}.}

\item{value}{Vector of length at most 4 of rotation angles (in degrees)
for an oblique projection, all values defaulting to zero. The values
indicate (longitude, latitude, orientation, orbit), as explained in the
Details section below.}

\item{name}{element name}
}
\value{
Either an \code{sf::crs} object or an \code{fm_crs} object,
depending on if the coordinate reference system described by the parameters
can be expressed with a pure \code{crs} object or not.

A \code{crs} object (\code{\link[sf:st_crs]{sf::st_crs()}}) or a \code{fm_crs} object.
An S3 \code{fm_crs} object is a list with elements \code{crs} and \code{oblique}.

\code{fm_wkt_predef} returns a WKT2 string defining a projection
}
\description{
Obtain an \code{sf::crs} or \code{fm_crs} object from a spatial object, or
convert crs information to construct a new \code{sf::crs} object.
}
\details{
The first two
elements of the \code{oblique} vector are the (longitude, latitude)
coordinates for the oblique centre point. The third value (orientation) is a
counterclockwise rotation angle for an observer looking at the centre point
from outside the sphere. The fourth value is the quasi-longitude (orbit
angle) for a rotation along the oblique observers equator.

Simple oblique: \code{oblique=c(0, 45)}

Polar: \code{oblique=c(0, 90)}

Quasi-transversal: \code{oblique=c(0, 0, 90)}

Satellite orbit viewpoint: \code{oblique=c(lon0-time*v1, 0, orbitangle, orbit0+time*v2)}, where \code{lon0} is the longitude at which a satellite
orbit crosses the equator at \code{time=0}, when the satellite is at an
angle \code{orbit0} further along in its orbit.  The orbital angle relative
to the equatorial plane is \code{orbitangle}, and \code{v1} and \code{v2}
are the angular velocities of the planet and the satellite, respectively.
Note that "forward" from the satellite's point of view is "to the right" in
the projection.

When \code{oblique[2]} or \code{oblique[3]} are non-zero, the resulting
projection is only correct for perfect spheres.
}
\section{Methods (by generic)}{
\itemize{
\item \code{st_crs(fm_crs)}: \code{st_crs(x, ...)} is equivalent to \code{fm_crs(x, ..., crsonly = TRUE)}
when \code{x} is a \code{fm_crs} object.

\item \code{$}: For a \code{fm_crs} object \code{x}, \code{x$name} calls the accessor method for the
\code{crs} object inside it. If \code{name} is "crs", the internal crs object itself is returned.
If \code{name} is "oblique", the internal oblique angle parameter vector is returned.

}}
\section{Functions}{
\itemize{
\item \code{fm_crs_is_null()}: Check if an object is or has \code{NULL} or \code{NA} CRS information

}}
\examples{
crs1 <- fm_crs("longlat_globe")
crs2 <- fm_crs("lambert_globe")
crs3 <- fm_crs("mollweide_norm")
crs4 <- fm_crs("hammer_globe")
crs5 <- fm_crs("sphere")
crs6 <- fm_crs("globe")
\dontrun{
names(fm_wkt_predef())
}
}
\seealso{
\code{\link[sf:st_crs]{sf::st_crs()}}, \code{\link{fm_crs_wkt}}
}
\author{
Finn Lindgren \email{finn.lindgren@gmail.com}
}
