% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spde.R
\name{materncov.bands}
\alias{materncov.bands}
\title{Matern correlation or covariance function approximate credible bands.}
\usage{
materncov.bands(
  manifold,
  dist,
  log.range,
  log.variance = NULL,
  alpha = 2,
  quantile = 0.95,
  n = 64,
  S1.L = NULL
)
}
\arguments{
\item{manifold}{Either "R1", "S1", "R2", or "S2", from
\code{mesh$manifold}, or a full \code{inla.mesh} or
\code{inla.mesh.1d} object.}

\item{dist}{A vector of distances at which to calculate the
covariances/correlations}

\item{log.range}{A scalar or a list (mean, sd), such as produced by
\code{inla.spde.result(...)$summary.log.range.nominal[[1]][c("mean","sd")]}}

\item{log.variance}{Either \code{NULL}, a scalar, or vector of the
same type as for log.range. When \code{NULL}, the correlations
are calculated instead of the covariances.}

\item{alpha}{The SPDE operator order. Default 2.}

\item{quantile}{The target credible probability. Default 0.95.}

\item{n}{The number of parameter combinations to use for the
approximation. Default 64.}

\item{S1.L}{For \code{manifold} \code{"S1"}, give the length of the
cyclic interval}
}
\value{
A list with estimated covariance or correlation (when \code{log.variance} is
\code{NULL}) functions:
\item{lower}{An approximate lower bound for the \code{quantile} credible region}
\item{median}{The function for for the approximate median parameters quantile}
\item{upper}{An approximate upper bound for the \code{quantile} credible region}
}
\description{
Evaluate the covariance function for an inla.spde
objectPlots the posterior distribution of the range,
log(range), variance, or log(variance) parameter of a model's
SPDE component. Can also plot Matern correlation or covariance
function.
}
\details{
Uses a Gaussian assumption for the internal model parameters, and finds a region in parameter
space with approximately \code{quantile} probability.
}
\author{
Finn Lindgren \email{Finn.Lindgren@ed.ac.uk}
}
\keyword{internal}
