% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PrintFigure.R
\name{PrintFigure}
\alias{PrintFigure}
\title{Print as LaTeX Figure}
\usage{
PrintFigure(fig, nr = 1, nc = 1, label = "", title = "",
  title_lof = title, headings = "", pos = "")
}
\arguments{
\item{fig}{'text'.
Vector of figure plotting commands written in \R.
The length of the vector is either equal to the number of subfigures,
or 1 when a single plot is desired.
An element in the vector contains the commands for creating a single plot.}

\item{nr, nc}{'integer'.
Maximum number of rows and columns in the subfigure layout on a page in the output document.}

\item{label}{'character'.
String containing the LaTeX label anchor.
Subfigures are labeled using a concatenation of the \code{label} argument and an index number.
For example, specifying \code{label = "id"} for a figure composed of 3 subfigures results in:
labels \code{"id-1"}, \code{"id-2"}, and \code{"id-3"}.}

\item{title}{'character'.
String containing the figure caption.}

\item{title_lof}{'character'.
String containing the figure caption to be listed at the beginning
of the paper in a \dQuote{List of Figures}.}

\item{headings}{'character'.
Vector of subfigure captions, values are recycled as necessary
to match the vector length of the \code{fig} argument.
To exclude a subfigure caption specify its vector element as \code{NA}.}

\item{pos}{'character'.
String for the placement specifiers to be used in \code{\\begin{figure}[pos]}.
The specifiers can consist of the following characters in any order:
\itemize{
  \item \code{"h"} place the float about at the same point it occurs in the source text;
  \item \code{"t"} position at the top of the page;
  \item \code{"b"} position at the bottom of the page;
  \item \code{"p"} put on a special page for floats only;
  \item \code{"!"} override internal parameters LaTeX uses for determining float positions; and
  \item \code{"H"} places the float at precisely the location in the source text,
    requires \code{\\usepackage{float}} in the LaTeX preamble.
}}
}
\value{
Invisible \code{NULL}
}
\description{
This function prints the LaTeX code associated with the supplied figure.
A figure can be composed of several subfigures
and passed to the function as \R plotting commands.
The applied output format attempts to adhere to the design recommendations
for figures in United States Geological Survey (USGS) publications.
}
\details{
Requires \code{\\usepackage{caption}} and \code{\\usepackage{subcaption}} in the LaTeX preamble.
  The width and height, in inches, to be used in the graphics device (that is, a single plot)
  are specified in the code-chunk options \code{fig.width} and \code{fig.height}, respectively.
  And always write raw results from \R into the output document
  by also specifying \code{results = "asis"} in the code-chunk options.
}
\examples{
\dontrun{
cat("\\\\documentclass{article}",
    "\\\\usepackage[labelsep=period, labelfont=bf]{caption}",
    "\\\\usepackage{subcaption}",
    "\\\\captionsetup[figure]{skip=5pt}",
    "\\\\captionsetup[subfigure]{skip=-5pt, labelfont={bf, it}}",
    "\\\\renewcommand{\\\\thesubfigure}{\\\\Alph{subfigure}}",
    "\\\\begin{document}\\n",
    "<<id, echo=FALSE, fig.width=3, fig.height=2, results='asis'>>=",
    "par(mar=c(2.1, 2.1, 1.1, 1.1))",
    "fig <- sprintf('plot(runif(\%s))', 1:9)",
    "headings <- sprintf('Subfigure caption, n=\%s', 1:9)",
    "PrintFigure(fig, 3, 2, 'id', title='Figure caption', headings=headings)",
    "@\\n",
    "\\\\end{document}",
    file = "figure-example.Rnw", sep = "\\n")
knitr::knit2pdf("figure-example.Rnw", clean = TRUE)  # requires TeX installation
system("open figure-example.pdf")

unlink("figure-example.*")
unlink("figure", recursive = TRUE)
}

}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
\keyword{print}
