% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waldtest.R
\name{waldtest}
\alias{waldtest}
\title{Wald test for \code{ciregic} and \code{ciregic_lt}}
\usage{
waldtest(obj1, obj2 = NULL, ...)
}
\arguments{
\item{obj1}{an object of the fitted model in \code{ciregic} or \code{ciregic_lt}}

\item{obj2}{an object of the fitted model in \code{ciregic} or \code{ciregic_lt}, the default is \code{NULL}}

\item{...}{further arguments}
}
\value{
The function \code{waldtest} returns an output table of Wald test of the model from \code{object}.
\item{varnames.full}{a variable name of a vector of variables names in the full model}
\item{varnames.nested}{a variable name of a vector of variables names in the nested model}
\item{vcov}{the estimated bootstrap variance-covariance matrix for overall Wald test}
\item{vcov.event1}{the estimated bootstrap variance-covariance matrix for cause-specific Wald test (event type 1)}
\item{vcov.event2}{the estimated bootstrap variance-covariance matrix for cause-specific Wald test (event type 2)}
\item{table}{a table including test statistic, degrees of freedom, and p-value}
}
\description{
\code{waldtest} for class \code{ciregic} or \code{ciregic_lt}. This provides the result of Wald test for the fitted model from the function \code{ciregic} or \code{ciregic_lt}.
}
\details{
The function \code{waldtest.ciregic} returns a result of Wald test.
}
\examples{
## Continuing the ciregic(...) example
waldtest(obj1 = fit)
set.seed(12345)
newdata <- dataprep(data = longdata, ID = id, time = t,
                    event = c, Z = c(z1, z2))
fit.nested <- ciregic(formula = Surv2(v = v, u = u, event = c) ~ z2, data = newdata,
               alpha = c(1, 1), nboot = 0, do.par = FALSE)
waldtest(obj1 = fit, obj2 = fit.nested)

}
\seealso{
The fitted semiparametric regression on cumulative incidence function with interval-censored competing risks data \code{\link[intccr]{ciregic}}
}
