% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doIntegration.R
\name{doIntegration}
\alias{doIntegration}
\title{Do integrative analysis}
\usage{
doIntegration(res, ref, type = "apeglm", apeAdapt = FALSE)
}
\arguments{
\item{res}{a list result from \code{doMatch} function.}

\item{ref}{specifying the reference level}

\item{type}{shrinkage estimator, default is "apeglm", the adaptive t prior shrinkage
estimator from the 'apeglm' package.}

\item{apeAdapt}{logical, should apeglm use the MLE estimates of LFC to adapt the prior,
or use default.}
}
\value{
df_final
a dataframe contains log2FoldChange of RNA-Seq and ChIP-Seq and Z scores
for each marker.
}
\description{
\code{doIntegration} calculate log2FoldChange of RNA-Seq and ChIP-Seq and
then calculate Z scores for each marker.
}
\examples{
data(res)
\donttest{doIntegration(res = res,ref="wild.type")
}

}
