% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensitynet.R
\name{NodeGeneralCorrelation.intensitynet}
\alias{NodeGeneralCorrelation.intensitynet}
\title{Gives general node correlation of the network (choosing from normal correlation, covariance, 
moran-i or geary)}
\usage{
\method{NodeGeneralCorrelation}{intensitynet}(obj, dep_type, lag_max, intensity)
}
\arguments{
\item{obj}{intensitynet object}

\item{dep_type}{'correlation', 'covariance', moran', 'geary'. The type of 
dependence statistic to be computed.}

\item{lag_max}{Maximum geodesic lag at which to compute dependence}

\item{intensity}{vector containing the intensity values that the heatmaps}
}
\value{
A vector containing the dependence statistics (ascending from order 0).
}
\description{
Gives general node correlation of the network (choosing from normal correlation, covariance, 
moran-i or geary)
}
\examples{

data("und_intnet_chicago")
g <- und_intnet_chicago$graph
gen_corr <- NodeGeneralCorrelation(und_intnet_chicago, dep_type = 'correlation', lag_max = 2, 
                                   intensity = igraph::vertex_attr(g)$intensity)

}
