% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/intensitynet.R
\name{ShortestPath}
\alias{ShortestPath}
\title{Calculates the shortest path between two vertices (based on the minimum amount of edges) and 
calculates its total weight}
\usage{
ShortestPath(obj, node_id1, node_id2, weight = NA, mode = "all")
}
\arguments{
\item{obj}{intensitynet object}

\item{node_id1}{starting node}

\item{node_id2}{ending node}

\item{weight}{an string, calculate the shortest path based on this type of weight. If no weight type is provided,
the function will calculate the shortest path based on the minimum amount of edges. Default NA.}

\item{mode}{Character 'in', 'out', 'all' (default). Gives whether the shortest paths to or from the given vertices 
should be calculated for directed graphs. If out then the shortest paths from the vertex, if in 
then to it will be considered. If all, the default, then the corresponding undirected graph will be used, ie. not 
directed paths are searched. This argument is ignored for undirected graphs.}
}
\value{
total weight of the shortest path and the path vertices with class igraph.vs
}
\description{
Calculates the shortest path between two vertices (based on the minimum amount of edges) and 
calculates its total weight
}
\examples{

data("und_intnet_chicago")
ShortestPath(und_intnet_chicago, node_id1 = 'V1', node_id2 = 'V300', weight = 'intensity')

}
