% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oracle_tfrp.R
\name{OracleTFRP}
\alias{OracleTFRP}
\title{Compute optimal adaptive tradable factor risk premia}
\usage{
OracleTFRP(
  returns,
  factors,
  penalty_parameters,
  weighting_type = "c",
  tuning_type = "g",
  relaxed = FALSE,
  include_standard_errors = FALSE,
  one_stddev_rule = FALSE,
  gcv_scaling_n_assets = FALSE,
  gcv_identification_check = FALSE,
  target_level_kp2006_rank_test = 0.05,
  n_folds = 5,
  n_train_observations = 120,
  n_test_observations = 12,
  roll_shift = 12,
  plot_score = TRUE,
  check_arguments = TRUE
)
}
\arguments{
\item{returns}{\verb{n_observations x n_returns}-dimensional matrix of test asset
excess returns.}

\item{factors}{\verb{n_observations x n_factors}-dimensional matrix of factors.}

\item{penalty_parameters}{\code{n_parameters}-dimensional vector of penalty
parameter values from smallest to largest.}

\item{weighting_type}{character specifying the type of adaptive weights:
based on the correlation between factors and returns \code{'c'}; based on the
regression coefficients of returns on factors \code{'b'}; based on the first-step
tradable risk premia estimator \code{'a'}; otherwise a vector of ones (any other
character). Default is \code{'c'}.}

\item{tuning_type}{character indicating the parameter tuning type: \code{'g'} for
generalized cross validation; \code{'r'} for rolling validation. Default is \code{'g'}.}

\item{relaxed}{boolean \code{TRUE} if you want to compute a post-selection
unpenalized tradable factor risk premia to remove the bias due to shrinkage;
FALSE\verb{otherwise. Default is}FALSE`.}

\item{include_standard_errors}{boolean \code{TRUE} if you want to compute the
adaptive tradable factor risk premia HAC standard errors; \code{FALSE} otherwise.
Default is \code{FALSE}.}

\item{one_stddev_rule}{boolean \code{TRUE} for picking the most parsimonious model
whose score is not higher than one standard error above the score of the
best model; \code{FALSE} for picking the best model. Default is \code{FALSE}.}

\item{gcv_scaling_n_assets}{(only relevant for \code{tuning_type ='g'})
boolean \code{TRUE} for sqrt(n_assets) scaling (\code{sqrt(n_assets) / n_observations});
\code{FALSE} otherwise (\code{1 / n_observations}). Default is \code{FALSE}.}

\item{gcv_identification_check}{(only relevant for \code{tuning_type ='g'})
boolean \code{TRUE} for a loose check for model
identification; \code{FALSE} otherwise. Default is \code{FALSE}.}

\item{target_level_kp2006_rank_test}{(only relevant for \code{tuning_type ='g'}
and if \code{gcv_identification_check} is
\code{TRUE}) numeric level of the Kleibergen Paap 2006 rank test. If it is
strictly grater than zero, then the iterative Kleibergen Paap 2006 rank
test at \code{level = target_level_kp2006_rank_test / n_factors} is used to compute an initial estimator
of the rank of the factor loadings in the Chen Fang 2019 rank test.
Otherwise, the initial rank estimator is taken to be the number of singular
values above \code{n_observations^(-1/4)}. Default is \code{0.05} (as correction
for multiple testing).}

\item{n_folds}{(only relevant for \code{tuning_type ='c'}) integer number of k-fold
for cross validation. Default is \code{5}.}

\item{n_train_observations}{(only relevant for \code{tuning_type ='r'}) number of
observations in the rolling training set. Default is \code{120}.}

\item{n_test_observations}{(only relevant for \code{tuning_type ='r'}) number of
observations in the test set. Default is \code{12}.}

\item{roll_shift}{(only relevant for \code{tuning_type ='r'}) number of observation
shift when moving from the rolling window to the next one. Default is \code{12}.}

\item{plot_score}{boolean \code{TRUE} for plotting the model score; \code{FALSE} otherwise.
Default is \code{TRUE}.}

\item{check_arguments}{boolean \code{TRUE} if you want to check function arguments;
\code{FALSE} otherwise. Default is \code{TRUE}.}
}
\value{
a list containing the \code{n_factors}-dimensional vector of adaptive
tradable factor risk premia in \code{"risk_premia"}; the optimal penalty
parameter value in \code{"penalty_parameter"}; the model score for each penalty
parameter value in \code{"model_score"};  if \code{include_standard_errors=TRUE}, then
it further includes \code{n_factors}-dimensional vector of tradable factor risk
premia standard errors in \code{"standard_errors"}.
}
\description{
Computes optimal adaptive tradable factor risk premia for
various penalty parameter values from data on factors and test asset excess
returns. Tuning is performed via Generalized Cross Validation (GCV),
Cross Validation (CV) or Rolling Validation (RV). Oracle weights can be based
on the correlation between factors and returns, on the regression
coefficients of returns on factors or on the first-step tradable risk premia
estimator. Optionally computes the corresponding heteroskedasticity and
autocorrelation robust standard errors using the Newey-West (1994) plug-in
procedure to select the number of relevant lags, i.e.,
\code{n_lags = 4 * (n_observations/100)^(2/9)}.
}
\examples{
# import package data on 15 risk factors and 42 test asset excess returns
factors = intrinsicFRP::factors[,-1]
returns = intrinsicFRP::returns[,-1]

penalty_parameters = seq(0., 1., length.out = 100)

# compute optimal adaptive tradable factor risk premia and their standard errors
oracle_tfrp = OracleTFRP(
returns,
factors,
penalty_parameters,
include_standard_errors = TRUE
)

}
