% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_params_flat.R
\name{get_params_flat}
\alias{get_params_flat}
\title{Get parameters to be optimized for flat model}
\usage{
get_params_flat(
  data,
  lower_bound = ggplot2::aes(Vdist = 0.01, Fgutabs = 0, Fgutabs_Vdist = 0.01,
    Rblood2plasma = 0.01),
  upper_bound = ggplot2::aes(Vdist = 100, Fgutabs = 1, Fgutabs_Vdist = 100, Rblood2plasma
    = 100),
  param_units = ggplot2::aes(Vdist = paste0("(", unique(Dose.Units), ")", "/", "(",
    unique(Conc.Units), ")"), Fgutabs = "unitless fraction", Fgutabs_Vdist = paste0("(",
    unique(Conc.Units), ")", "/", "(", unique(Dose.Units), ")"), Rblood2plasma =
    "unitless ratio")
)
}
\arguments{
\item{data}{The data set to be fitted (e.g. the result of [preprocess_data()])}

\item{lower_bound}{A mapping specified using a call to [ggplot2::aes()],
giving the lower bounds for each variable, as expressions which may include
variables in `data`.}

\item{upper_bound}{A mapping specified using a call to [ggplot2::aes()],
giving the upper bounds for each variable, as expressions which may include
variables in `data`.}

\item{param_units}{A mapping specified using a call to [ggplot2::aes()],
giving the units for each variable, as expressions which may include
variables in `data`.}
}
\value{
A `data.frame`with the following variables:
- `param_name`: Character: Names of the model parameters
- `param_units`: Character: Units of the model parameters
- `optimize_param`: TRUE if each parameter is to be estimated from the data; FALSE otherwise
- `use_param`: TRUE if each parameter is to be used in evaluating the model; FALSE otherwise
-`lower_bounds`: Numeric: The lower bounds for each parameter
- `upper_bounds`: Numeric: The upper bounds for each parameter
- `start`: Numeric: The starting guesses for each parameter
}
\description{
The full set of model parameters for the flat model includes
`Vdist`, `Fgutabs`, and `Rblood2plasma`. Whether each one can be estimated
from the data depends on what routes of administration are included in the
data.
}
\details{
## IV data, no oral data

If IV dosing data are available, but no oral dosing data are available, then
only the parameter `Vdist` will be estimated from the data. The
parameter `Fgutabs` cannot be estimated from IV data alone and will not be used to evaluate the model.

## Oral data, no IV data

If oral dosing data are available, but no IV dosing data are available, then
the parameters `Fgutabs` and `Vdist` cannot be identified separately. From
oral data alone, only the ratio `Fgutabs/Vdist` can be identified. This ratio
is represented by a single parameter named `Fgutabs_Vdist`. `Fgutabs` and
`Vdist` will not be estimated nor used in model evaluation, but `Fgutabs_Vdist` will be estimated.

## Oral data and IV data

If both oral and IV dosing data are available, then `Vdist` and `Fgutabs` will both be estimated from the data.

# Blood and plasma data

If both blood and plasma data are available, then `Rblood2plasma` will be estimated from the data.

# Only one of blood or plasma data

If only one of blood or plasma data are available, then `Rblood2plasma` will be
held constant at 1, not estimated from the data.

# Default lower and upper bounds for each parameter

## Default lower and upper bounds for `Vdist`

By default, the lower bound for `Vdist` is 0.01, and the upper bound for
`Vdist` is 100. These values were chosen based on professional judgment.

## Default lower and upper bounds for `Fgutabs`

By default, the lower bound for `Fgutabs` is 0.0, and the upper bound for
`Fgutabs` is 1. These are simply the bounds of the physically-meaningful
range for a fraction.

## Default lower and upper bounds for `Fgutabs_Vdist`

By default, the lower bound for the ratio `Fgutabs_Vdist` is 0.01, and the
upper bound is 100. These values were chosen based on professional judgment.

## Default lower and upper bounds for `Rblood2plasma`

By default, the lower bound for the blood:plasma partition coefficient
`Rblood2plasma` is 0.01, and the upper bound is 100. These values were chosen
based on professional judgment.

# Starting values for each parameter

Starting values for each parameter (starting guesses for the numerical
optimizer) are derived from the data using [get_starts_flat()].

If the starting values returned by [get_starts_flat()] fall outside the
bounds for any parameter(s), then the starting value will be reset to a value
halfway between the lower and upper bounds for that parameter.
}
\seealso{
Other flat model functions: 
\code{\link{auc_flat}()},
\code{\link{cp_flat}()},
\code{\link{get_starts_flat}()}

Other get_params functions: 
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_1comp_fup}()},
\code{\link{get_params_2comp}()}

Other built-in model functions: 
\code{\link{auc_1comp}()},
\code{\link{auc_1comp_cl}()},
\code{\link{auc_2comp}()},
\code{\link{auc_flat}()},
\code{\link{cp_1comp}()},
\code{\link{cp_1comp_cl}()},
\code{\link{cp_2comp}()},
\code{\link{cp_2comp_dt}()},
\code{\link{cp_flat}()},
\code{\link{get_params_1comp}()},
\code{\link{get_params_1comp_cl}()},
\code{\link{get_params_1comp_fup}()},
\code{\link{get_params_2comp}()},
\code{\link{get_starts_1comp}()},
\code{\link{get_starts_1comp_cl}()},
\code{\link{get_starts_1comp_fup}()},
\code{\link{get_starts_2comp}()},
\code{\link{get_starts_flat}()},
\code{\link{tkstats_2comp}()},
\code{\link{transformed_params_2comp}()}
}
\author{
Caroline Ring
}
\concept{built-in model functions}
\concept{flat model functions}
\concept{get_params functions}
