% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk_method_aafe.R
\name{AAFE.pk}
\alias{AAFE.pk}
\title{Calculate absolute average fold error (AAFE)}
\usage{
\method{AAFE}{pk}(
  obj,
  newdata = NULL,
  model = NULL,
  method = NULL,
  exclude = TRUE,
  use_scale_conc = FALSE,
  AAFE_group = NULL,
  sub_pLOQ = TRUE,
  ...
)
}
\arguments{
\item{obj}{A `pk` object}

\item{newdata}{Optional: A `data.frame` with new data for which to make
predictions and compute AAFE. If NULL (the default), then AAFE will be
computed for the data in `obj$data`. `newdata` is required to contain at
least the following variables: `Time`, `Time.Units`, `Dose`, `Route`,
`Media`, `Conc`, `Conc_SD`, `N_Subjects`, `Detect`, `pLOQ`.}

\item{model}{Optional: Specify one or more of the fitted models for which to
make predictions and calculate AAFE. If NULL (the default), AAFE will be
returned for all of the models in `obj$stat_model`.}

\item{method}{Optional: Specify one or more of the [optimx::optimx()] methods
for which to make predictions and calculate AAFE. If NULL (the default),
RMSEs will be returned for all of the models in
`obj$optimx_settings$method`.}

\item{exclude}{Logical: `TRUE` to compute the AAFE excluding any observations
in the data marked for exclusion (if there is a variable `exclude` in the
data, an observation is marked for exclusion when `exclude %in% TRUE`).
`FALSE` to include all observations, regardless of exclusion status.
Default `TRUE`.}

\item{use_scale_conc}{Possible values: `TRUE`, `FALSE`, or a named list with
elements `dose_norm` and `log10_trans` which themselves should be either
`TRUE` or `FALSE`. If `use_scale_conc = TRUE`, then the concentration
scaling/transformations in `object` will be applied to both predicted and
observed concentrations before the log-likelihood is computed. If
`use_scale_conc = FALSE` (the default for this function), then no
concentration scaling or transformation will be applied before the
log-likelihood is computed. If `use_scale_conc = list(dose_norm = ...,
log10_trans = ...)`, then the specified dose normalization and/or
log10-transformation will be applied.}

\item{AAFE_group}{Default: Chemical, Species. Determines what the data
grouping that is used to calculate absolute average fold error (AAFE). Should be set to lowest number
of variables that still would return unique experimental conditions.
Input in the form of `ggplot2::vars(Chemical, Species, Route, Media, Dose)`.}

\item{sub_pLOQ}{TRUE (default): Substitute all predictions below the LOQ with
the LOQ before computing AAFE. FALSE: do not.}

\item{...}{Additional arguments. Not currently in use.}
}
\value{
A dataframe with one row for each `data_group`, `model` and `method`.
  The final column contains the AAFE of the model fitted by the corresponding
  method, using the data in `newdata`.
}
\description{
Calculate aboslute average fold error (AAFE)
}
\details{
Absolute average fold error (AAFE) is calculated as

\deqn{
10^{\frac{1}{N}\sum{ \textrm{abs} \left[
log_{10} \left(
 \frac{\textrm{predicted}}{\textrm{observed}}
  \right)
  \right]
  }
  }
}

# Left-censored data

If the observed value is censored, and the predicted value is less than the
reported LOQ, then the observed value is (temporarily) set equal to the
predicted value, for an effective error of zero.

If the predicted value is less than the reported LOQ, then the user may
choose whether to (temporarily) set the predicted value equal to LOQ, using
argument `sub_pLOQ`).
}
\seealso{
Other fit evaluation metrics: 
\code{\link{AFE.pk}()},
\code{\link{AIC.pk}()},
\code{\link{BIC.pk}()},
\code{\link{logLik.pk}()},
\code{\link{rmse.pk}()},
\code{\link{rsq.pk}()}

Other methods for fitted pk objects: 
\code{\link{AFE.pk}()},
\code{\link{AIC.pk}()},
\code{\link{BIC.pk}()},
\code{\link{coef.pk}()},
\code{\link{coef_sd.pk}()},
\code{\link{eval_tkstats.pk}()},
\code{\link{get_fit.pk}()},
\code{\link{get_hessian.pk}()},
\code{\link{get_tkstats.pk}()},
\code{\link{logLik.pk}()},
\code{\link{predict.pk}()},
\code{\link{residuals.pk}()},
\code{\link{rmse.pk}()},
\code{\link{rsq.pk}()}
}
\author{
Caroline Ring
}
\concept{fit evaluation metrics}
\concept{methods for fitted pk objects}
