% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfProx}
\alias{ipfProx}
\title{Estimates the position of the observations from its fingerprints and the access point location
usins a logarithmic path loss model}
\usage{
ipfProx(dataRSSI, wapLOC, locdata = NULL, rssirange = c(-100, 0),
  norssi = NA, alpha = 5, wapPow1 = -30)
}
\arguments{
\item{dataRSSI}{a matrix or a data frame containing the RSSI data (fingerprints) of the
observations}

\item{wapLOC}{a matrix or a data frame containing the position of the wireless access
points, in the same order as they appear in dataRSSI}

\item{locdata}{a matrix or a data frame containing the position of the data set observations}

\item{rssirange}{range of the RSSI data}

\item{norssi}{value used to represent a not detected AP}

\item{alpha}{path loss exponent}

\item{wapPow1}{detected RSSI at one meter range}
}
\value{
An S4 class object of type ipfEstimation, with the following slots:
                 location ->   a matrix with the predicted locations
                 grouploc ->   NULL
                 errors   ->   a numeric vector with the errors, if loctest has been provided
}
\description{
Estimates the position of the observations from its fingerprints and the access point location
usins a logarithmic path loss model
}
\examples{

    ipfEst <- ipfProx(ipftrain[1:10, 1:168], ipfpwap, ipftrain[1:10, 169:170], alpha = 4)

}
