% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{define_extract}
\alias{define_extract}
\title{Define an IPUMS extract object}
\description{
Specify the parameters for a new IPUMS extract request object to be
submitted via the IPUMS API. An extract request contains the specifications
required to obtain a particular set of data from an IPUMS collection.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\section{Supported collections}{

Currently, ipumsr supports extract definitions for the following
collections:
\itemize{
\item \strong{IPUMS USA}: \code{\link[=define_extract_usa]{define_extract_usa()}}
\item \strong{IPUMS CPS}: \code{\link[=define_extract_cps]{define_extract_cps()}}
\item \strong{IPUMS International}: \code{\link[=define_extract_ipumsi]{define_extract_ipumsi()}}
\item \strong{IPUMS NHGIS}: \code{\link[=define_extract_nhgis]{define_extract_nhgis()}}
}
}

\section{Value}{

These functions produce an \code{\link[=ipums_extract-class]{ipums_extract}} object
with a subclass based on the collection corresponding to the extract request.
The core ipumsr API client tools are designed to handle these objects.
}

\keyword{internal}
