% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itempool-class-methods.R
\name{[,Itempool,ANY,missing-method}
\alias{[,Itempool,ANY,missing-method}
\title{Subset \code{Itempool} objects}
\usage{
\S4method{[}{Itempool,ANY,missing}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{x}{An \code{\link{Itempool-class}} object from which to extract
element(s) or in which to replace element(s).}

\item{i}{indices specifying elements to extract or replace.}

\item{j}{This will not be used in \code{\link{Itempool-class}} objects.}

\item{...}{Parameters to be passed to the function.}

\item{drop}{(From R manual:) For matrices and arrays. If TRUE the result is
coerced to the lowest possible dimension (see the examples). This only works
for extracting elements, not for the replacement. See drop for further
details.}
}
\value{
An \code{\link{Itempool-class}} object with elements from
  \code{\link{Item-class}}.
}
\description{
Subset \code{Itempool} objects
}
\examples{
ip <- itempool(a = c(1.12, 2.1, 1.28), b = c(2, 3.2, 0.21),
                item_id = c("i1", "i2", "i3"))

ip[1]
# Create an Itempool using the first and third element:
ip[c(1, 3)] # Order is important
ip[c(3, 1)]
ip[-2]
ip[c(TRUE, FALSE, TRUE)]
ip[c("i2", "i1")]
# Recycle, i.e. get all elements
ip[TRUE]
}
\author{
Emre Gonulates
}
\keyword{internal}
