% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpdb.R
\name{to_VPDB}
\alias{to_VPDB}
\title{Converting isotope delta from VSMOW to VPDB}
\usage{
to_VPDB(d18O_VSMOW, eq = "IUPAC")
}
\arguments{
\item{d18O_VSMOW}{d18O values expressed on the VSMOW scale (‰).}

\item{eq}{Equation used for the conversion.
\itemize{
\item \code{"IUPAC"} (default): the IUPAC recommended equation
listed in Brand et al. (2014) and Kim et al. (2015).
\item \code{"Coplen83"}: the equation listed in Coplen et al. (1983)
and the Hoefs book.
}}
}
\value{
Returns the d18O value expressed on the VPDB scale (‰).
}
\description{
\code{to_VPDB()} convert d18O value expressed on the VSMOW scale
to the VPDB scale.
}
\details{
The IUPAC recommended equation to convert between the scales is:

\deqn{\delta^{18}O_{VPDB} = 0.97001 \times \delta^{18}O_{VSMOW} - 29.99}
}
\examples{
to_VPDB(0)
to_VPDB(0, eq = "Coplen83")

}
\references{
References are listed at \code{\link[=to_VSMOW]{to_VSMOW()}}.
}
\seealso{
\code{\link[=to_VSMOW]{to_VSMOW()}} converts d18O values expressed on the VPDB scale
to the VSMOW scale.
}
