% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_data.R
\name{iso_get_file_info}
\alias{iso_get_file_info}
\title{Aggregate file info}
\usage{
iso_get_file_info(
  iso_files,
  select = everything(),
  file_specific = FALSE,
  simplify = TRUE,
  quiet = default(quiet)
)
}
\arguments{
\item{iso_files}{collection of iso_file objects}

\item{select}{which columns to select - use \code{c(...)} to select multiple, supports all \link[dplyr]{select} syntax including renaming columns. File id is always included and cannot be renamed.}

\item{file_specific}{whether to run the select criteria (\code{...}) specifically within each individual file rather than on all files jointly. This is a lot slower but makes it possible to  select different columns in different iso_files depending on what exists in each file and is mostly of use when working with data from multiple instruments.}

\item{simplify}{if set to TRUE (the default), nested value columns in the file info will be unnested as long as they are compatible across file types. Note that file info entries with multiple values still remain nested multi-value (=list) columns even with \code{simplify=TRUE}. These can be unnested using \link[tidyr:nest]{unnest}.}

\item{quiet}{whether to display (quiet=FALSE) or silence (quiet = TRUE) information messages. Set parameter to overwrite global defaults for this function or set global defaults with calls to \link[=iso_info_messages]{iso_turn_info_messages_on} and \link[=iso_info_messages]{iso_turn_info_messages_off}}
}
\description{
Combine file information from multiple iso_files. By default all information is included but specific columns can be targeted using the \code{select} parameter to select and/or rename columns. File information beyond \code{file_id}, \code{file_root}, \code{file_path}, \code{file_datetime} and \code{file_size} (in bytes) is only available if the \code{iso_files} were read with parameter \code{read_file_info=TRUE}.
}
\note{
this function used to allow selecting/renaming different file_info_columns in different files to the same column. This was a significant speed impediment and only covered very rare use cases. It is still available in the related function \code{\link{iso_select_file_info}} with a special flag but is no longer the default and not encouraged for use in the frequently called \code{iso_get_file_info}.
}
\seealso{
Other data retrieval functions: 
\code{\link{iso_get_all_data}()},
\code{\link{iso_get_bgrd_data}()},
\code{\link{iso_get_raw_data}()},
\code{\link{iso_get_resistors}()},
\code{\link{iso_get_standards}()},
\code{\link{iso_get_vendor_data_table}()}
}
\concept{data retrieval functions}
