% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes.R
\docType{class}
\name{Specie}
\alias{Specie}
\alias{.R_Specie_ctor}
\title{Class providing object with methods to mimic in silico Genomes}
\value{
Objects of R6 class with methods to mimic in silico Genomes.
}
\description{
Mean to mimic a in silico Genomes. It is the machine instances of
    the simulator.
}
\details{
Object of R6 class that points to C++ objetcs.
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{.ptr}}{External pointer to the instance of the C++ class Specie.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{.R_Specie_ctor$new()}}
\item \href{#method-print}{\code{.R_Specie_ctor$print()}}
\item \href{#method-founder}{\code{.R_Specie_ctor$founder()}}
\item \href{#method-gamete}{\code{.R_Specie_ctor$gamete()}}
\item \href{#method-map}{\code{.R_Specie_ctor$map()}}
\item \href{#method-clone}{\code{.R_Specie_ctor$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an instance of a Specie.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specie_ctor$new(ptr)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ptr}}{an Smart pointer to an instance of a Specie C++ class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new `Specie` object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print/Show an instance of the Specie class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specie_ctor$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{further arguments to be passed to print.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-founder"></a>}}
\if{latex}{\out{\hypertarget{method-founder}{}}}
\subsection{Method \code{founder()}}{
Constructor of a Founder Instances of the Specimen Class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specie_ctor$founder(code)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{code}}{a length one character vector with one of the genotype codes:
"AA", "Aa", "aA" or "aa".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-gamete"></a>}}
\if{latex}{\out{\hypertarget{method-gamete}{}}}
\subsection{Method \code{gamete()}}{
Generate gamete prototypes for this specie.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specie_ctor$gamete(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{an integer number with the number of gametes prototype to be generated.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a vector of strings with the gamete prototypes.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-map"></a>}}
\if{latex}{\out{\hypertarget{method-map}{}}}
\subsection{Method \code{map()}}{
Retrieve the map of the current specie.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specie_ctor$map()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a data.frame with the map of the specie.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.R_Specie_ctor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
