% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_resources_cubes.R
\name{get_datasets_agency_resource}
\alias{get_datasets_agency_resource}
\title{Get datasets (agencyID / resourceID)}
\usage{
get_datasets_agency_resource(agencyID, resourceID, lang = "es",
  limit = 25, offset = 0, orderBy = NULL, query = NULL)
}
\arguments{
\item{agencyID}{(string) Identifier of the maintainer organization of the resource. A possible value is \code{ISTAC}.}

\item{resourceID}{(string) Resource identifier. A possible value is \code{C00010A_000002}.}

\item{lang}{(string) Language in which you want to get the answer.}

\item{limit}{(int) Results limit. By default \code{limit = 25}.}

\item{offset}{(int) Displacement. Result from which it is returned. By default \code{offset = 0}.}

\item{orderBy}{(string) Order. Possible values are \code{ID ASC} or \code{ID DESC},}

\item{query}{(string) Metadata query on which the searches can be built.}
}
\description{
This function allows to obtain all the versions of a statistical cube with a certain identifier and that also maintains a certain organization.
}
\examples{
get_datasets_agency_resource(agencyID = "ISTAC", resourceID = "C00010A_000002")
}
