% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/plot_topo.R
\name{plot_topo}
\alias{plot_topo}
\title{Visualization of EEG topo maps.}
\usage{
plot_topo(model, view, el.pos = NULL, fun = "fvisgam",
  add.color.legend = TRUE, size = 5, n.grid = 100, col = 1, pch = 21,
  bg = alpha(1), color = "topo", xlab = "", ylab = "", ...)
}
\arguments{
\item{model}{A gam object, produced by \code{\link[mgcv]{gam}} or
\code{\link[mgcv]{bam}}.}

\item{view}{A two-value vector containing the names of the two main effect
terms to be displayed on the x and y dimensions of the plot. Note that
variables coerced to factors in the model formula won't work as view
variables.}

\item{el.pos}{A list with X and Y positions and Electrodes, which are used
for fitting the model.}

\item{fun}{Text string, "fvisgam", "pvisgam", or "plot_diff2" signalling
which function to use for plotting.}

\item{add.color.legend}{Logical: whether or not to add a color legend.
Default is TRUE. If FALSE (omitted), one could use the function
\code{\link{gradientLegend}} to add a legend manually at any position.}

\item{size}{Size in inch of plot window.}

\item{n.grid}{The number of grid nodes in each direction used for
calculating the plotted surface.}

\item{col}{The colors for the background of the plot.}

\item{pch}{The type of points as indications for the electrode positions.
The value NA will suppress the plotting of electrode positions.}

\item{bg}{The background color of the points.}

\item{color}{The color scheme to use for plots. One of "topo", "heat",
"cm", "terrain", "gray" or "bw".}

\item{xlab}{Label x-axis. Default excluded.}

\item{ylab}{Label y-axis. Default excluded.}

\item{...}{other options to pass on to \code{\link{fvisgam}},
\code{\link{pvisgam}}, or \code{\link{plot_diff2}}.}
}
\description{
Visualization of EEG topo maps.
}
\section{Notes}{

X-positions of electrodes should have lower values for electrodes on the
left hemisphere (e.g. T7) than for electrodes on the right
hemisphere.
Y-positions of electrodes should have lower values for electrodes at the
back of the head than for the frontal electrodes.
}
\examples{
data(eeg)

\dontrun{
# simple GAMM model:
m1 <- gam(Ampl ~ te(Time, X, Y, k=c(10,5,5),
    d=c(1,2)), data=eeg)

# topo plot, by default uses fvisgam
# and automatically selects a timestamp (270ms):
plot_topo(m1, view=c("X", "Y"))

# add electrodes:
electrodes <- eeg[,c('X','Y','Electrode')]
electrodes <- as.list( electrodes[!duplicated(electrodes),] )
plot_topo(m1, view=c("X", "Y"), el.pos=electrodes)

# some formatting options:
plot_topo(m1, view=c("X", "Y"), el.pos=electrodes,
    main="Topo plot", zlim=c(-.5,.5),
    pch=15, col='red', color='terrain')

# plotting more than one panel only works if
# each figure region is a square:
dev.new(width=12, height=4)
par(mfrow=c(1,3))

for(i in c(100, 200, 300)){
    # make sure to keep zlim constant:
	   plot_topo(m1, view=c('X', 'Y'), zlim=c(-.5, .5),
    cond=list(Time=i), el.pos=electrodes,
    main=i)
}

dev.new(width=12, height=4)
par(mfrow=c(1,3), cex=1.1)
# The three different functions for plotting:
plot_topo(m1, view=c('X', 'Y'), zlim=c(-.5, .5),
    el.pos=electrodes,
    fun='fvisgam', main='fvisgam',
    cond=list(Time=200), rm.ranef=TRUE)
plot_topo(m1, view=c('X', 'Y'), zlim=c(-.5, .5),
    el.pos=electrodes, select=1,
    fun='pvisgam', main='pvisgam',
    cond=list(Time=200))
plot_topo(m1, view=c('X', 'Y'), zlim=c(-.5, .5),
    el.pos=electrodes, comp=list(Time=c(300,100)),
    fun='plot_diff2', main='plot_diff2',
    plotCI=TRUE)

# Add labels:
plot_topo(m1, view=c('X', 'Y'), zlim=c(-.5, .5),
    fun='fvisgam', main='',
    cond=list(Time=200), add.color.legend=FALSE)
text(electrodes[['X']], electrodes[['Y']],
    labels=electrodes[['Electrode']], cex=.75,
    xpd=TRUE)
}
}
\author{
Jacolien van Rij
}
\seealso{
Other functions for interpreting nonlinear effects: \code{\link{fvisgam}},
  \code{\link{vis.gam2}}; \code{\link{plotDiff2D}},
  \code{\link{plot_diff2}}; \code{\link{plotDiff}},
  \code{\link{plot_diff}}; \code{\link{plot_parametric}};
  \code{\link{plot_smooth}}; \code{\link{pvis.gam}},
  \code{\link{pvisgam}}
}

