% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{getProps}
\alias{getProps}
\title{Transform coordinates into proportions of the figure or plot region.}
\usage{
getProps(pos, side = 1, output = "p")
}
\arguments{
\item{pos}{A number indicating the coordinates on the x- or y-axis.}

\item{side}{Which axis to choose: 1=bottom, 2=left, 3=top, 4=right. Default is 1.}

\item{output}{Which proportion to take: with respect to the plot region 
(input 'p', default), or with respect to figure region (output 'f').}
}
\description{
Function for positioning a legend or label in or outside the 
plot region based on proportion of the plot region rather than Cartesian 
coordinates.
}
\examples{
# not very easy-to-calculate-with x- and y-axis values
emptyPlot(c(-2.35, 37.4), c(9,11), v0=0)
# draw a mirror symmetric image of boxes:
p1 <- c(9.5, 9.5)
p2 <- c(4,9.7)
p3 <- c(20,9)
p1m <- getCoords(1-getProps(p1, side=c(1,2)), side=c(1,2))
p2m <- getCoords(1-getProps(p2, side=c(1,2)), side=c(1,2))
p3m <- getCoords(1-getProps(p3, side=c(1,2)), side=c(1,2))
xdist <- diff(getCoords(c(0,.1), side=1))
ydist <- diff(getCoords(c(0,.1), side=2))
rect(xleft=c(p1[1],p2[1], p3[1], p1m[1], p2m[1], p3m[1])-xdist, 
    xright=c(p1[1],p2[1], p3[1], p1m[1], p2m[1], p3m[1])+xdist,
    ybottom=c(p1[2],p2[2], p3[2], p1m[2], p2m[2], p3m[2])-ydist, 
    ytop=c(p1[2],p2[2], p3[2], p1m[2], p2m[2], p3m[2])+ydist, 
    col=rep(c("red", NA, "lightblue"),2), xpd=TRUE )

}
\author{
Jacolien van Rij
}
\seealso{
\code{\link{getCoords}}, \code{\link{getFigCoords}}

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{alphaPalette}},
  \code{\link{alpha}}, \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawArrows}}, \code{\link{emptyPlot}},
  \code{\link{errorBars}}, \code{\link{fadeRug}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{gradientLegend}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}, \code{\link{rug_model}}
}

