% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.ReducedImageStack}
\alias{print.ReducedImageStack}
\title{Print summary information from \code{ReducedImageStack} object.}
\usage{
\method{print}{ReducedImageStack}(x, ...)
}
\arguments{
\item{x}{(\code{ReducedImageStack}) A \code{ReducedImageStack} object to be messaged.
It could be the return of function \code{\link{dim_reduce}}.}

\item{...}{Not used.}
}
\value{
The same object that was passed as input.
}
\description{
Display the most general and informative characteristics of
a ReducedImageStack object, including the set threshold, original variables,
and the selected variables and the correlations between them.
}
\examples{
\donttest{
library(itsdm)
library(dplyr)
library(stars)
env_vars <- system.file(
  'extdata/bioclim_tanzania_10min.tif',
  package = 'itsdm') \%>\% read_stars()

img_reduced <- dim_reduce(env_vars, threshold = 0.7,
  preferred_vars = c('bio1', 'bio12'))

print(img_reduced)
}

}
\seealso{
\code{\link{dim_reduce}}
}
