% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Polynomials.R
\name{JackPol}
\alias{JackPol}
\title{Jack polynomial}
\usage{
JackPol(n, lambda, alpha, algorithm = "DK", basis = "canonical")
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{alpha}{parameter of the Jack polynomial, a positive number, possibly
a \code{\link[gmp]{bigq}} rational number}

\item{algorithm}{the algorithm used, either \code{"DK"} or \code{"naive"}}

\item{basis}{the polynomial basis for \code{algorithm = "naive"},
either \code{"canonical"} or \code{"MSF"} (monomial symmetric functions);
for \code{algorithm = "DK"} the canonical basis is always used and
this parameter is ignored}
}
\value{
A \code{mvp} multivariate polynomial (see \link[mvp]{mvp-package}),
 or a \code{\link[gmpoly]{gmpoly}} multivariate polynomial if \code{alpha}
 is a \code{bigq} rational number and \code{algorithm = "DK"}, or a
 character string if \code{basis = "MSF"}.
}
\description{
Returns the Jack polynomial.
}
\examples{
JackPol(3, lambda = c(3,1), alpha = gmp::as.bigq(2,3),
                  algorithm = "naive")
JackPol(3, lambda = c(3,1), alpha = 2/3, algorithm = "DK")
JackPol(3, lambda = c(3,1), alpha = gmp::as.bigq(2,3), algorithm = "DK")
JackPol(3, lambda = c(3,1), alpha= gmp::as.bigq(2,3),
        algorithm = "naive", basis = "MSF")
}
