% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jackstraw.R
\name{jackstraw.FUN}
\alias{jackstraw.FUN}
\title{Non-Parametric Jackstraw for a Custom Function}
\usage{
jackstraw.FUN(dat, FUN, r = NULL, r1 = NULL, s = NULL, B = NULL,
  covariate = NULL, compute.obs = TRUE, compute.null = TRUE,
  compute.p = TRUE, verbose = TRUE, seed = NULL)
}
\arguments{
\item{dat}{a data matrix with \code{m} rows as variables and \code{n} columns as observations.}

\item{FUN}{optionally, provide a specfic function to estimate LVs. Must output \code{r} estimated LVs in a \code{n*r} matrix.}

\item{r}{a number of significant latent variables.}

\item{r1}{a numeric vector of latent variables of interest.}

\item{s}{a number of ``synthetic'' null variables. Out of \code{m} variables, \code{s} variables are independently permuted.}

\item{B}{a number of resampling iterations.}

\item{covariate}{a model matrix of covariates with \code{n} observations. Must include an intercept in the first column.}

\item{compute.obs}{a logical specifying to return observed statistics. By default, \code{TRUE}.}

\item{compute.null}{a logical specifying to return null statistics obtained by the jackstraw method. By default, \code{TRUE}.}

\item{compute.p}{a logical specifying to return p-values. By default, \code{TRUE}.}

\item{verbose}{a logical specifying to print the computational progress.}

\item{seed}{a seed for the random number generator.}
}
\value{
\code{jackstraw} returns a list consisting of
\item{p.value}{\code{m} p-values of association tests between variables and their principal components}
\item{obs.stat}{\code{m} observed statistics}
\item{null.stat}{\code{s*B} null statistics}
}
\description{
Estimates statistical significance of association between variables and their latent variables, estimated using a custom function.
}
\examples{
set.seed(1234)
## simulate data from a latent variable model: Y = BL + E
B = c(rep(1,50),rep(-1,50), rep(0,900))
L = rnorm(20)
E = matrix(rnorm(1000*20), nrow=1000)
dat = B \%*\% t(L) + E
dat = t(scale(t(dat), center=TRUE, scale=TRUE))

## apply the jackstraw with the svd as a function
out = jackstraw.FUN(dat, FUN = function(x) svd(x)$v[,1,drop=FALSE], r=1, s=100, B=50)
}
\references{
Chung and Storey (2013) Statistical Significance of Variables Driving Systematic Variation in High-Dimensional Data. arXiv:1308.6013 [stat.ME] \url{http://arxiv.org/abs/1308.6013}
}
\seealso{
\link{jackstraw}
}
\author{
Neo Christopher Chung \email{nchchung@gmail.com}
}
