% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-string.r
\name{mixedSorts}
\alias{mixedSorts}
\title{sort alphanumeric values within a list format}
\usage{
mixedSorts(
  x,
  blanksFirst = TRUE,
  na.last = NAlast,
  keepNegative = FALSE,
  keepInfinite = TRUE,
  keepDecimal = FALSE,
  ignore.case = TRUE,
  useCaseTiebreak = TRUE,
  sortByName = FALSE,
  na.rm = FALSE,
  verbose = FALSE,
  NAlast = TRUE,
  honorFactor = TRUE,
  xclass = NULL,
  indent = 0,
  debug = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{vector}}

\item{blanksFirst}{\code{logical} whether to order blank entries before entries
containing a value.}

\item{na.last}{\code{logical} indicating whether to move NA entries at
the end of the sort.}

\item{keepNegative}{\code{logical} whether to keep '-' associated with adjacent
numeric values, in order to sort them as negative values.}

\item{keepInfinite}{\code{logical} whether to allow "Inf" to be considered
a numeric infinite value.}

\item{keepDecimal}{\code{logical} whether to keep the decimal in numbers,
sorting as a true number and not as a version number. By default
keepDecimal=FALSE, which means "v1.200" should be ordered before
"v1.30". When keepDecimal=TRUE, the numeric sort considers only
"1.2" and "1.3" and sorts in that order.}

\item{ignore.case}{\code{logical} whether to ignore uppercase and lowercase
characters when defining the sort order. Note that when \code{x} is
\code{factor} the factor levels are converted using
\code{unique(toupper(levels(x)))}, therefore the values in \code{x} will be
sorted by factor level.}

\item{useCaseTiebreak}{\code{logical} indicating whether to break ties
when \code{ignore.case=TRUE}, using mixed case as a tiebreaker.}

\item{sortByName}{\code{logical} whether to sort the vector x by names(x) instead
of sorting by x itself.}

\item{na.rm}{\code{logical}, default FALSE, indicating whether to remove
NA values.}

\item{verbose}{\code{logical} whether to print verbose output.}

\item{NAlast}{\code{logical} deprecated in favor of argument \code{na.last}
for consistency with \code{base::sort()}.}

\item{honorFactor}{\code{logical}, default TRUE, used to enforce factor level
sort order, when FALSE it sorts as \code{character}.}

\item{xclass}{\code{character} vector of classes in \code{x}, used for slight
optimization to re-use this vector if it has already been
defined for \code{x}. When \code{NULL} it is created within this function.}

\item{indent}{\code{numeric} used only when \code{verbose=TRUE} to determine
the number of spaces indented for verbose output, passed to
\code{printDebug()}.}

\item{debug}{\code{logical}, default FALSE, whether to print detailed
debug output.}

\item{...}{additional parameters are sent to \code{\link{mixedOrder}}.}
}
\value{
\code{list} after applying \code{mixedSort()} to its elements.
}
\description{
sort alphanumeric values within a list format
}
\details{
This function is an extension to \code{mixedSort()} to sort each vector
in a list. It applies the sort to the whole unlisted vector then
splits back into list form.

In the event the input is a nested list of lists, only the first
level of list structure is maintained in the output data. For
more information, see \code{rlengths()} which calculates the recursive
nested list sizes. An exception is when the data contained in \code{x}
represents multiple classes, see below.

When data in \code{x} represents multiple classes, for example \code{character}
and \code{factor}, the mechanism is slightly different and not as well-
optimized for large length \code{x}. The method uses
\code{rapply(x, how="replace", mixedSort)} which recursively, and iteratively,
calls \code{mixedSort()} on each vector, and therefore returns data in the
same nested \code{list} structure as provided in \code{x}.

When data in \code{x} represents only one class, data is \code{unlist()} to one
large vector, which is sorted with \code{mixedSort()}, then split back into
\code{list} structure representing \code{x} input.
}
\examples{
# set up an example list of mixed alpha-numeric strings
set.seed(12);
x <- paste0(sample(letters, replace=TRUE, 52), rep(1:30, length.out=52));
x;
# split into a list as an example
xL <- split(x, rep(letters[1:5], c(6,7,5,4,4)));
xL;

# now run mixedSorts(xL)
# Notice "e6" is sorted before "e30"
mixedSorts(xL)

# for fun, compare to lapply(xL, sort)
# Notice "e6" is sorted after "e30"
lapply(xL, sort)

# test super-long list
xL10k <- rep(xL, length.out=10000);
names(xL10k) <- as.character(seq_along(xL10k));
print(head(mixedSorts(xL10k), 10))

# Now make some list vectors into factors
xF <- xL;
xF$c <- factor(xL$c)
# for fun, reverse the levels
xF$c <- factor(xF$c,
   levels=rev(levels(xF$c)))
xF
mixedSorts(xF)

# test super-long list
xF10k <- rep(xF, length.out=10000);
names(xF10k) <- as.character(seq_along(xF10k));
print(head(mixedSorts(xF10k), 10))

# Make a nested list
set.seed(1);
l1 <- list(
   A=sample(nameVector(11:13, rev(letters[11:13]))),
   B=list(
      C=sample(nameVector(4:8, rev(LETTERS[4:8]))),
      D=sample(nameVector(LETTERS[2:5], rev(LETTERS[2:5])))
   )
)
l1;
# The output is a nested list with the same structure
mixedSorts(l1);
mixedSorts(l1, sortByName=TRUE);

# Make a nested list with two sub-lists
set.seed(1);
l2 <- list(
   A=list(
      E=sample(nameVector(11:13, rev(letters[11:13])))
   ),
   B=list(
      C=sample(nameVector(4:8, rev(LETTERS[4:8]))),
      D=sample(nameVector(LETTERS[2:5], rev(LETTERS[2:5])))
   )
)
l2;
# The output is a nested list with the same structure
mixedSorts(l2);
mixedSorts(l2, sortByName=TRUE);

# when one entry is missing
L0 <- list(A=3:1,
   B=list(C=c(1:3,NA,0),
   D=LETTERS[c(4,5,2)],
   E=NULL));
L0
mixedSorts(L0)
mixedSorts(L0, na.rm=TRUE)

}
\seealso{
Other jam sort functions: 
\code{\link{mixedOrder}()},
\code{\link{mixedSort}()},
\code{\link{mixedSortDF}()},
\code{\link{mmixedOrder}()}

Other jam list functions: 
\code{\link{cPaste}()},
\code{\link{heads}()},
\code{\link{jam_rapply}()},
\code{\link{list2df}()},
\code{\link{mergeAllXY}()},
\code{\link{rbindList}()},
\code{\link{relist_named}()},
\code{\link{rlengths}()},
\code{\link{sclass}()},
\code{\link{sdim}()},
\code{\link{uniques}()},
\code{\link{unnestList}()}
}
\concept{jam list functions}
\concept{jam sort functions}
