% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-colors.r
\name{rgb2col}
\alias{rgb2col}
\title{Convert RGB color matrix to R color}
\usage{
rgb2col(
  red,
  green = NULL,
  blue = NULL,
  alpha = NULL,
  names = NULL,
  maxColorValue = NULL,
  keepNA = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{red}{\code{numeric} vector of red values; or RGB numeric matrix with
rownames c("red","green","blue") in any order, with optional rowname
"alpha"; or character strings with comma-separated rgb values, in
format "100,20,10". The latter input is designed to handle web rgb
values.}

\item{green}{\code{numeric} vector, or when red is a matrix or comma-delimited
character string, this parameter is ignored.}

\item{blue}{\code{numeric} vector, or when red is a matrix or comma-delimited
character string, this parameter is ignored.}

\item{alpha}{\code{numeric} vector, or when red is a matrix or comma-delimited
character string, this parameter is ignored. Alpha values are always
expected in range \verb{[0,1]}, even when \code{maxColorValue} is higher
than \code{1}. When \code{alpha} is \code{FALSE}, the alpha transparency is removed.
When \code{alpha} is \code{TRUE} the original alpha transparency is retained
without change. If supplying \code{alpha} as a numeric vector, use \code{Inf}
to represent \code{TRUE} for alpha values to be kept without change, and
use \code{-1} or any negative number to indicate alpha values to remove
from the output.}

\item{names}{\code{character}, default NULL, with optional names to apply
to output colors.}

\item{maxColorValue}{\code{numeric} maximum value for colors. If NULL then it
defaults to 1 unless there are values above 1, in which case it defaults
to 255.}

\item{keepNA}{\code{logical} whether to keep NA values, returning NA for any
input where red, green, and/or blue are NA. If keepNA==FALSE then it
substitutes 0 for any NA values.}

\item{verbose}{\code{logical} indicating whether to print verbose output}

\item{...}{Additional arguments are ignored.}
}
\value{
\code{character} vector of R colors.
}
\description{
Convert RGB color matrix to R color
}
\details{
This function intends to augment the \code{\link[grDevices]{rgb}} function, which
does not handle output from \code{\link[grDevices]{col2rgb}}. The goal is to handle
multiple color conversions, e.g. \code{rgb2col(grDevices::col2rgb("red"))}. This
function also maintains alpha transparency when supplied.

The output is named either by names(red), rownames(red), or if supplied,
the value of the parameter \code{names}.

Note that \code{alpha} is used to define alpha transparency, but has
additional control over the output.
\itemize{
\item When \code{alpha} is \code{FALSE} then
output colors will not have the alpha transparency, in hex form that
means colors are in format \code{"#RRGGBB"} and not \code{"#RRGGBBAA"}.
\item When \code{alpha} is \code{TRUE} the previous alpha transparency values are
used without change.
\item When \code{alpha} is a numeric vector, numeric values are always
expected to be in range \verb{[0,1]}, where \code{0} is completely transparent,
and \code{1} is completely not transparent. Supplied \code{alpha} values will
override those present in \code{red} when \code{red} is a matrix like that
produced from \code{grDevices::col2rgb(..., alpha=TRUE)}.
\item When \code{alpha} is a numeric vector, use \code{-1} or any negative number
to indicate the alpha value should be removed.
\item When \code{alpha} is a numeric vector, use \code{Inf} to indicate the alpha
transparency should be retained without change.
}

Therefore, \code{alpha = c(-1, 0, 1, Inf)} will apply the following,
in order: remove alpha; set alpha to 0; set alpha to 1; set alpha
to the same as the input color.
}
\examples{
# start with a color vector
# red and blue with partial transparency
colorV <- c("#FF000055", "#00339999");

# Show the output of rgb2col
# make sure to include alpha=TRUE to maintain alpha transparency
grDevices::col2rgb(colorV, alpha=TRUE);

# confirm we can convert from RGB back to the same colors
rgb2col(grDevices::col2rgb(colorV, alpha=TRUE));

}
\seealso{
Other jam color functions: 
\code{\link{alpha2col}()},
\code{\link{applyCLrange}()},
\code{\link{col2alpha}()},
\code{\link{col2hcl}()},
\code{\link{col2hsl}()},
\code{\link{col2hsv}()},
\code{\link{color2gradient}()},
\code{\link{fixYellow}()},
\code{\link{fixYellowHue}()},
\code{\link{getColorRamp}()},
\code{\link{hcl2col}()},
\code{\link{hsl2col}()},
\code{\link{hsv2col}()},
\code{\link{isColor}()},
\code{\link{kable_coloring}()},
\code{\link{makeColorDarker}()},
\code{\link{rainbow2}()},
\code{\link{setCLranges}()},
\code{\link{setTextContrastColor}()},
\code{\link{showColors}()},
\code{\link{unalpha}()},
\code{\link{warpRamp}()}
}
\concept{jam color functions}
