% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_first_valid_of.R
\name{use_first_valid_of}
\alias{use_first_valid_of}
\title{Returns first non-NA value from a set of vectors.}
\usage{
use_first_valid_of(..., if_all_NA = NA)
}
\arguments{
\item{...}{the input vectors.  Order matters: these are searched and prioritized in the order they are supplied.}

\item{if_all_NA}{what value should be used when all of the vectors return \code{NA} for a certain index?  Default is NA.}
}
\value{
Returns a single vector with the selected values.
}
\description{
At each position of the input vectors, iterates through in order and returns the first non-NA value.  This is a robust replacement of the common \code{ifelse(!is.na(x), x, ifelse(!is.na(y), y, z))}.  It's more readable and handles problems like \code{ifelse}'s inability to work with dates in this way.
}
\examples{
x <- c(1, NA, NA); y <- c(2, 2, NA); z <- c(3, 3, 3)
use_first_valid_of(x, y, z)
use_first_valid_of(y, x, if_all_NA = 0)
}

