% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adorn_rounding.R
\name{adorn_rounding}
\alias{adorn_rounding}
\title{Round the numeric columns in a data.frame.}
\usage{
adorn_rounding(dat, digits = 1, rounding = "half to even",
  skip_first_col = TRUE)
}
\arguments{
\item{dat}{a data.frame with at least one numeric column}

\item{digits}{how many digits should be displayed after the decimal point?}

\item{rounding}{method to use for rounding - either "half to even", the base R default method, or "half up", where 14.5 rounds up to 15.}

\item{skip_first_col}{should the first column be left unrounded, assuming it contains values of a descriptive variable as in a \code{tabyl}?  Defaults to \code{TRUE}.}
}
\value{
Returns the data.frame with rounded numeric columns.
}
\description{
Can run on any data.frame with at least one numeric column.  This function defaults to excluding the first column of the input data.frame, assuming that it contains a descriptive variable, but this can be overridden with the argument \code{skip_first_col = FALSE}.

If you're formatting percentages, e.g., the result of \code{adorn_percentages()}, use \code{adorn_pct_formatting()} instead.  This is a more flexible variant for ad-hoc usage.  Compared to \code{adorn_pct_formatting()}, it can run on the first column and does not multiply by 100 or pad the numbers with spaces for alignment in the results data.frame.   This function retains the class of numeric input columns.
}
\examples{

mtcars \%>\%
  tabyl(am, cyl) \%>\%
  adorn_percentages() \%>\%
  adorn_rounding(digits = 2, rounding = "half up")

# tolerates non-numeric columns:
library(dplyr)
mtcars \%>\%
  tabyl(am, cyl) \%>\%
  adorn_percentages("all") \%>\%
  mutate(dummy = "a") \%>\%
  adorn_rounding()
}
