% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/line.R
\name{mesh_line}
\alias{mesh_line}
\title{Draw line segments between regional meshes}
\usage{
mesh_line(mesh, mesh_to, close = FALSE, skip_na = FALSE)
}
\arguments{
\item{mesh}{A \code{mesh} vector or a list of \code{mesh} vector.}

\item{mesh_to}{A \code{mesh} vector.}

\item{close}{Should the path of each element be closed when \code{mesh} is a list?}

\item{skip_na}{Should skip the \code{NA} mesh and connects the paths? \code{FALSE} by default.}
}
\value{
A list of \code{mesh} class vectors.
}
\description{
If \code{mesh} and \code{mesh_to} are both vectors, the line between \code{mesh} and \code{mesh_to} is drawn (using Bresenham's line algorithm).
If \code{mesh} is a list, The path lines for each element in the mesh will be drawn.
}
